/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Public
public abstract class NumericTypeInfo<T>
extends BasicTypeInfo<T> {
    private static final long serialVersionUID = -5937777910658986986L;
    private static final HashSet<Class<?>> numericalTypes = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Double.class, Byte.class, Short.class, Float.class, Character.class));

    protected NumericTypeInfo(Class<T> clazz, Class<?>[] possibleCastTargetTypes, TypeSerializer<T> serializer, Class<? extends TypeComparator<T>> comparatorClass) {
        super(clazz, possibleCastTargetTypes, serializer, comparatorClass);
        Preconditions.checkArgument(numericalTypes.contains(clazz), "The given class %s is not a numerical type", clazz.getSimpleName());
    }
}

