/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.alert.impl;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.streampark.common.util.AssertUtils;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.console.base.exception.AlertException;
import org.apache.streampark.console.base.util.SpringContextUtils;
import org.apache.streampark.console.core.bean.AlertConfigWithParams;
import org.apache.streampark.console.core.bean.AlertTemplate;
import org.apache.streampark.console.core.entity.AlertConfig;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.AlertType;
import org.apache.streampark.console.core.enums.CheckPointStatus;
import org.apache.streampark.console.core.enums.FlinkAppState;
import org.apache.streampark.console.core.service.alert.AlertConfigService;
import org.apache.streampark.console.core.service.alert.AlertNotifyService;
import org.apache.streampark.console.core.service.alert.AlertService;
import org.apache.streampark.console.core.service.alert.impl.DingTalkAlertNotifyServiceImpl;
import org.apache.streampark.console.core.service.alert.impl.EmailAlertNotifyServiceImpl;
import org.apache.streampark.console.core.service.alert.impl.HttpCallbackAlertNotifyServiceImpl;
import org.apache.streampark.console.core.service.alert.impl.LarkAlertNotifyServiceImpl;
import org.apache.streampark.console.core.service.alert.impl.WeComAlertNotifyServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AlertServiceImpl
implements AlertService {
    private static final Logger log = LoggerFactory.getLogger(AlertServiceImpl.class);
    @Autowired
    private AlertConfigService alertConfigService;
    private final ExecutorService notifyExecutor = new ThreadPoolExecutor(1, 2, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.threadFactory((String)"streampark-notify"));

    @Override
    public void alert(Application application, CheckPointStatus checkPointStatus) {
        AlertTemplate alertTemplate = AlertTemplate.of(application, checkPointStatus);
        this.notifyExecutor.submit(() -> this.alert(application, alertTemplate));
    }

    @Override
    public void alert(Application application, FlinkAppState appState) {
        AlertTemplate alertTemplate = AlertTemplate.of(application, appState);
        this.notifyExecutor.submit(() -> this.alert(application, alertTemplate));
    }

    private void alert(Application application, AlertTemplate alertTemplate) {
        Integer alertId = application.getAlertId();
        if (alertId == null) {
            return;
        }
        AlertConfig alertConfig = (AlertConfig)this.alertConfigService.getById(alertId);
        try {
            this.alert(AlertConfigWithParams.of(alertConfig), alertTemplate);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean alert(AlertConfigWithParams params, AlertTemplate alertTemplate) throws AlertException {
        List<AlertType> alertTypes = AlertType.decode(params.getAlertType());
        if (CollectionUtils.isEmpty(alertTypes)) {
            return true;
        }
        Tuple2 reduce = alertTypes.stream().map(alertType -> {
            try {
                Class<? extends AlertNotifyService> notifyServiceClass = this.getAlertServiceImpl((AlertType)((Object)alertType));
                AssertUtils.notNull(notifyServiceClass);
                boolean alertRes = SpringContextUtils.getBean(notifyServiceClass).doAlert(params, alertTemplate);
                return new Tuple2((Object)alertRes, null);
            }
            catch (AlertException e) {
                return new Tuple2((Object)false, (Object)e);
            }
        }).reduce(new Tuple2((Object)true, null), (tp1, tp2) -> {
            boolean alertResult = (Boolean)tp1.f0 & (Boolean)tp2.f0;
            if (tp1.f1 == null && tp2.f1 == null) {
                return new Tuple2((Object)((Boolean)tp1.f0 & (Boolean)tp2.f0), null);
            }
            if (tp1.f1 != null && tp2.f1 != null) {
                AlertException alertException = new AlertException(((AlertException)tp1.f1).getMessage() + "\n" + ((AlertException)tp2.f1).getMessage(), (Throwable)tp1.f1);
                return new Tuple2((Object)alertResult, (Object)alertException);
            }
            return new Tuple2((Object)alertResult, (Object)(tp1.f1 == null ? (AlertException)tp2.f1 : (AlertException)tp1.f1));
        });
        if (reduce.f1 != null) {
            throw (AlertException)reduce.f1;
        }
        return (Boolean)reduce.f0;
    }

    private Class<? extends AlertNotifyService> getAlertServiceImpl(AlertType alertType) {
        switch (alertType) {
            case EMAIL: {
                return EmailAlertNotifyServiceImpl.class;
            }
            case DING_TALK: {
                return DingTalkAlertNotifyServiceImpl.class;
            }
            case WE_COM: {
                return WeComAlertNotifyServiceImpl.class;
            }
            case LARK: {
                return LarkAlertNotifyServiceImpl.class;
            }
            case HTTP_CALLBACK: {
                return HttpCallbackAlertNotifyServiceImpl.class;
            }
        }
        return null;
    }
}

