/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.task;

import org.apache.streampark.flink.packer.PackerResourceGC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PackerResourceGCTask {
    private static final Logger log = LoggerFactory.getLogger(PackerResourceGCTask.class);
    @Value(value="${streampark.packer-gc.max-resource-expired-hours:120}")
    public Integer maxResourceIntervalHours;

    @Scheduled(cron="${streampark.packer-gc.exec-cron:0 0 0/6 * * ?}")
    public void collectGarbage() {
        log.info("[streampark-packer] Starting Packer Resource GC Task.");
        PackerResourceGC.startGc((Integer)this.maxResourceIntervalHours);
    }
}

