/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ComputerAwareStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class IdentityRemovalStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final IdentityRemovalStrategy INSTANCE = new IdentityRemovalStrategy();

    private IdentityRemovalStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (traversal.getSteps().size() <= 1) {
            return;
        }
        for (IdentityStep identityStep : TraversalHelper.getStepsOfClass(IdentityStep.class, traversal)) {
            boolean isEndStep;
            if (!identityStep.getLabels().isEmpty() && identityStep.getPreviousStep() instanceof EmptyStep) continue;
            boolean bl = isEndStep = identityStep.getNextStep() instanceof ComputerAwareStep.EndStep || identityStep.getNextStep() instanceof RepeatStep.RepeatEndStep;
            if (isEndStep && traversal.getSteps().size() == 2) continue;
            TraversalHelper.copyLabels(identityStep, identityStep.getPreviousStep(), false);
            traversal.removeStep(identityStep);
        }
    }

    public static IdentityRemovalStrategy instance() {
        return INSTANCE;
    }
}

