/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class TraversalFlatMapStep<S, E>
extends FlatMapStep<S, E>
implements TraversalParent {
    private Traversal.Admin<S, E> flatMapTraversal;

    public TraversalFlatMapStep(Traversal.Admin traversal, Traversal<S, E> flatMapTraversal) {
        super(traversal);
        this.flatMapTraversal = this.integrateChild(flatMapTraversal.asAdmin());
    }

    @Override
    protected Iterator<E> flatMap(Traverser.Admin<S> traverser) {
        return TraversalUtil.applyAll(traverser, this.flatMapTraversal);
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return Collections.singletonList(this.flatMapTraversal);
    }

    @Override
    public TraversalFlatMapStep<S, E> clone() {
        TraversalFlatMapStep clone = (TraversalFlatMapStep)super.clone();
        clone.flatMapTraversal = this.flatMapTraversal.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.flatMapTraversal);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.flatMapTraversal);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.flatMapTraversal.hashCode();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }
}

