/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceLockSet;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractFileResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.concurrent.KeyedReentrantReadWriteLock;
import org.apache.tomcat.util.http.RequestUtil;

public class DirResourceSet
extends AbstractFileResourceSet
implements WebResourceLockSet {
    private static final Log log = LogFactory.getLog(DirResourceSet.class);
    private KeyedReentrantReadWriteLock resourceLocksByPath = new KeyedReentrantReadWriteLock();

    public DirResourceSet() {
        super("/");
    }

    public DirResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath) {
        super(internalPath);
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        if (root.getContext().getAddWebinfClassesResources()) {
            File f = new File(base, internalPath);
            if ((f = new File(f, "/WEB-INF/classes/META-INF/resources")).isDirectory()) {
                root.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", f.getAbsolutePath(), null, "/");
            }
        }
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResource getResource(String path) {
        this.checkPath((String)path);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root = this.getRoot();
        boolean readOnly = this.isReadOnly();
        if (this.isPathMounted((String)path, webAppMount)) {
            Lock readLock = null;
            if (!readOnly) {
                readLock = this.getLock((String)path).readLock();
                readLock.lock();
            }
            try {
                File f = this.file(((String)path).substring(webAppMount.length()), false);
                if (f == null) {
                    EmptyResource emptyResource = new EmptyResource(root, (String)path);
                    return emptyResource;
                }
                if (!f.exists()) {
                    EmptyResource emptyResource = new EmptyResource(root, (String)path, f);
                    return emptyResource;
                }
                if (f.isDirectory() && ((String)path).charAt(((String)path).length() - 1) != '/') {
                    path = (String)path + "/";
                }
                FileResource fileResource = new FileResource(root, (String)path, f, readOnly, this.getManifest(), this, (String)(readOnly ? null : path));
                return fileResource;
            }
            finally {
                if (readLock != null) {
                    readLock.unlock();
                }
            }
        }
        return new EmptyResource(root, (String)path);
    }

    @Override
    public String[] list(String path) {
        this.checkPath((String)path);
        String webAppMount = this.getWebAppMount();
        if (this.isPathMounted((String)path, webAppMount)) {
            File f = this.file(((String)path).substring(webAppMount.length()), true);
            if (f == null) {
                return EMPTY_STRING_ARRAY;
            }
            String[] result = f.list();
            return Objects.requireNonNullElse(result, EMPTY_STRING_ARRAY);
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if (webAppMount.startsWith((String)path)) {
            int i = webAppMount.indexOf(47, ((String)path).length());
            if (i == -1) {
                return new String[]{webAppMount.substring(((String)path).length())};
            }
            return new String[]{webAppMount.substring(((String)path).length(), i)};
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> listWebAppPaths(String path) {
        this.checkPath((String)path);
        String webAppMount = this.getWebAppMount();
        ResourceSet<String> result = new ResourceSet<String>();
        if (this.isPathMounted((String)path, webAppMount)) {
            File[] list;
            File f = this.file(((String)path).substring(webAppMount.length()), true);
            if (f != null && (list = f.listFiles()) != null) {
                String fCanPath = null;
                for (File entry : list) {
                    if (!this.getAllowLinking()) {
                        boolean symlink = true;
                        String absPath = null;
                        String canPath = null;
                        try {
                            absPath = entry.getAbsolutePath().substring(f.getAbsolutePath().length());
                            String entryCanPath = entry.getCanonicalPath();
                            if (fCanPath == null) {
                                fCanPath = f.getCanonicalPath();
                            }
                            if (entryCanPath.length() >= fCanPath.length() && absPath.equals(canPath = entryCanPath.substring(fCanPath.length()))) {
                                symlink = false;
                            }
                        }
                        catch (IOException ioe) {
                            canPath = "Unknown";
                        }
                        if (symlink) {
                            this.logIgnoredSymlink(this.getRoot().getContext().getName(), absPath, canPath);
                            continue;
                        }
                    }
                    StringBuilder sb = new StringBuilder((String)path);
                    if (((String)path).charAt(((String)path).length() - 1) != '/') {
                        sb.append('/');
                    }
                    sb.append(entry.getName());
                    if (entry.isDirectory()) {
                        sb.append('/');
                    }
                    result.add(sb.toString());
                }
            }
        } else {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            if (webAppMount.startsWith((String)path)) {
                int i = webAppMount.indexOf(47, ((String)path).length());
                if (i == -1) {
                    result.add(webAppMount + "/");
                } else {
                    result.add(webAppMount.substring(0, i + 1));
                }
            }
        }
        result.setLocked(true);
        return result;
    }

    @Override
    public boolean mkdir(String path) {
        this.checkPath(path);
        if (this.isReadOnly()) {
            return false;
        }
        String webAppMount = this.getWebAppMount();
        if (this.isPathMounted(path, webAppMount)) {
            File f = this.file(path.substring(webAppMount.length()), false);
            if (f == null) {
                return false;
            }
            return f.mkdir();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(String path, InputStream is, boolean overwrite) {
        this.checkPath(path);
        if (is == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (path.endsWith("/")) {
            return false;
        }
        String webAppMount = this.getWebAppMount();
        if (!this.isPathMounted(path, webAppMount)) {
            return false;
        }
        Lock writeLock = this.getLock(path).writeLock();
        writeLock.lock();
        try {
            File dest = this.file(path.substring(webAppMount.length()), false);
            if (dest == null) {
                boolean bl = false;
                return bl;
            }
            if (dest.exists() && !overwrite) {
                boolean bl = false;
                return bl;
            }
            try {
                if (overwrite) {
                    Files.copy(is, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(is, dest.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException ioe) {
                boolean bl = false;
                writeLock.unlock();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    protected void checkType(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(sm.getString("dirResourceSet.notDirectory", this.getBase(), File.separator, this.getInternalPath()));
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        File mf;
        super.initInternal();
        if (this.getWebAppMount().isEmpty() && (mf = this.file("META-INF/MANIFEST.MF", true)) != null && mf.isFile()) {
            try (FileInputStream fis = new FileInputStream(mf);){
                this.setManifest(new Manifest(fis));
            }
            catch (IOException ioe) {
                log.warn(sm.getString("dirResourceSet.manifestFail", mf.getAbsolutePath()), ioe);
            }
        }
        if (this.isReadOnly()) {
            return;
        }
        if (JreCompat.getInstance().isCanonCachesDisabled()) {
            return;
        }
        if (!JreCompat.getInstance().disableCanonCaches()) {
            throw new IllegalStateException(sm.getString("dirResourceSet.canonCaches.enabled", this.getFileBase(), this.getRoot().getContext().getName()));
        }
        log.warn(sm.getString("dirResourceSet.canonCaches.disabled", this.getFileBase(), this.getRoot().getContext().getName()));
    }

    private String getLockKey(String path) {
        return RequestUtil.normalize(path).toLowerCase(Locale.ENGLISH);
    }

    @Override
    public ReadWriteLock getLock(String path) {
        String key = this.getLockKey(path);
        return this.resourceLocksByPath.getLock(key);
    }

    @Override
    public WebResourceLockSet.ResourceLock lockForRead(String path) {
        String key = this.getLockKey(path);
        this.resourceLocksByPath.getLock(key).readLock().lock();
        return new WebResourceLockSet.ResourceLock(key);
    }

    @Override
    public void unlockForRead(WebResourceLockSet.ResourceLock resourceLock) {
        this.resourceLocksByPath.getLock(resourceLock.key).readLock().unlock();
    }

    @Override
    public WebResourceLockSet.ResourceLock lockForWrite(String path) {
        String key = this.getLockKey(path);
        this.resourceLocksByPath.getLock(key).writeLock().lock();
        return new WebResourceLockSet.ResourceLock(key);
    }

    @Override
    public void unlockForWrite(WebResourceLockSet.ResourceLock resourceLock) {
        this.resourceLocksByPath.getLock(resourceLock.key).writeLock().unlock();
    }
}

