/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.util;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static int getArrayLength(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        throw new IllegalArgumentException("This is not an array! " + String.valueOf(array));
    }

    public static List<Integer> asList(final int[] vals) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Short> asList(final short[] vals) {
        return new AbstractList<Short>(){

            @Override
            public Short get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Long> asList(final long[] vals) {
        return new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Character> asList(final char[] vals) {
        return new AbstractList<Character>(){

            @Override
            public Character get(int index) {
                return Character.valueOf(vals[index]);
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Byte> asList(final byte[] vals) {
        return new AbstractList<Byte>(){

            @Override
            public Byte get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Float> asList(final float[] vals) {
        return new AbstractList<Float>(){

            @Override
            public Float get(int index) {
                return Float.valueOf(vals[index]);
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static List<Double> asList(final double[] vals) {
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return vals[index];
            }

            @Override
            public int size() {
                return vals.length;
            }
        };
    }

    public static Type getArrayTypeFor(Class<?> clazz) {
        if (Boolean.TYPE == clazz) {
            return boolean[].class;
        }
        if (Byte.TYPE == clazz) {
            return byte[].class;
        }
        if (Character.TYPE == clazz) {
            return char[].class;
        }
        if (Short.TYPE == clazz) {
            return short[].class;
        }
        if (Integer.TYPE == clazz) {
            return int[].class;
        }
        if (Long.TYPE == clazz) {
            return long[].class;
        }
        if (Float.TYPE == clazz) {
            return float[].class;
        }
        if (Double.TYPE == clazz) {
            return double[].class;
        }
        if (Boolean.class == clazz) {
            return Boolean[].class;
        }
        if (Byte.class == clazz) {
            return Byte[].class;
        }
        if (Character.class == clazz) {
            return Character[].class;
        }
        if (Short.class == clazz) {
            return Short[].class;
        }
        if (Integer.class == clazz) {
            return Integer[].class;
        }
        if (Long.class == clazz) {
            return Long[].class;
        }
        if (Float.class == clazz) {
            return Float[].class;
        }
        if (Double.class == clazz) {
            return Double[].class;
        }
        return Array.newInstance(clazz, 0).getClass();
    }
}

