/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public class JavaVersions {
    public static final int VERSION;
    private static final Class<?>[] EMPTY_CLASSES;

    public static Class<?>[] getParameterizedTypes(Field f) {
        try {
            return JavaVersions.collectParameterizedTypes(f.getGenericType(), f.getType());
        }
        catch (Exception e) {
            return EMPTY_CLASSES;
        }
    }

    public static Class<?>[] getParameterizedTypes(Method meth) {
        try {
            return JavaVersions.collectParameterizedTypes(meth.getGenericReturnType(), meth.getReturnType());
        }
        catch (Exception e) {
            return EMPTY_CLASSES;
        }
    }

    private static Class<?>[] collectParameterizedTypes(Type type, Class<?> cls) throws Exception {
        if (type instanceof ParameterizedType) {
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            Class[] clss = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Class<?> c = JavaVersions.extractClass(args[i]);
                if (c == null) {
                    return EMPTY_CLASSES;
                }
                clss[i] = c;
            }
            return clss;
        }
        if (cls.getSuperclass() != Object.class) {
            return JavaVersions.collectParameterizedTypes(cls.getGenericSuperclass(), cls.getSuperclass());
        }
        return EMPTY_CLASSES;
    }

    static Class<?> extractClass(Type type) throws Exception {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return JavaVersions.extractClass(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    static {
        EMPTY_CLASSES = new Class[0];
        String specVersion = AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction("java.specification.version"));
        if ("1.2".equals(specVersion)) {
            VERSION = 2;
        } else if ("1.3".equals(specVersion)) {
            VERSION = 3;
        } else if ("1.4".equals(specVersion)) {
            VERSION = 4;
        } else if ("1.5".equals(specVersion)) {
            VERSION = 5;
        } else if ("1.6".equals(specVersion)) {
            VERSION = 6;
        } else if ("1.7".equals(specVersion)) {
            VERSION = 7;
        } else if ("1.8".equals(specVersion)) {
            VERSION = 8;
        } else {
            int v;
            try {
                v = Integer.parseInt(specVersion);
            }
            catch (NumberFormatException nfe) {
                v = 8;
            }
            VERSION = v;
        }
    }
}

