/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi.openid.storage.impl;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Base64;
import java.util.Objects;
import org.apache.tomee.security.cdi.openid.storage.OpenIdStorageHandler;

public class CookieBasedOpenIdStorageHandler
extends OpenIdStorageHandler {
    @Override
    public String get(HttpServletRequest request, HttpServletResponse response, String key) {
        for (Cookie cookie : request.getCookies()) {
            if (!Objects.equals(cookie.getName(), "openid." + key)) continue;
            return new String(Base64.getDecoder().decode(cookie.getValue()));
        }
        return null;
    }

    @Override
    public void set(HttpServletRequest request, HttpServletResponse response, String key, String value) {
        Cookie cookie = new Cookie("openid." + key, Base64.getEncoder().encodeToString(value.getBytes()));
        cookie.setSecure(request.isSecure());
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    @Override
    public void delete(HttpServletRequest request, HttpServletResponse response, String key) {
        Cookie cookie = new Cookie("openid." + key, null);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }
}

