/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.DiscoveryRegistry;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceManager;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class ServiceManagerExtender
extends ServiceManager {
    static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE, (String)"org.apache.openejb.server.util.resources");
    private final BundleContext bundleContext;
    private BundleTracker tracker;
    private final Map<Bundle, List<Service>> serverMap = new HashMap<Bundle, List<Service>>();
    private Boolean started;
    private volatile boolean stopped = false;

    public ServiceManagerExtender(BundleContext bundleContext) {
        ServiceManagerExtender.setServiceManager(this);
        this.bundleContext = bundleContext;
    }

    @Override
    public void init() throws Exception {
        if (this.started != null && this.started.equals(Boolean.TRUE)) {
            throw new IllegalStateException("ServiceManager is already initialized");
        }
        DiscoveryRegistry registry = new DiscoveryRegistry();
        SystemInstance.get().setComponent(DiscoveryRegistry.class, (Object)registry);
        this.started = Boolean.FALSE;
        this.stopped = false;
        ServerServiceTracker t = new ServerServiceTracker();
        this.tracker = new BundleTracker(this.bundleContext, 48, (BundleTrackerCustomizer)t);
        this.tracker.open();
    }

    @Override
    public synchronized void start(boolean block) throws ServiceException {
        if (this.started == null) {
            throw new ServiceException("ServiceManager not initialized");
        }
        if (this.stopped) {
            throw new ServiceException("ServiceManager has already been stopped");
        }
        this.started = Boolean.TRUE;
        for (Map.Entry<Bundle, List<Service>> entry : this.serverMap.entrySet()) {
            for (Service service : entry.getValue()) {
                service.start();
            }
        }
    }

    private synchronized void startServers(Bundle bundle, List<Service> services) {
        this.serverMap.put(bundle, services);
        if (this.started == Boolean.TRUE) {
            for (Service service : services) {
                service.start();
            }
        }
    }

    protected void addedServers(Bundle bundle, Map<String, Properties> resources) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Map.Entry<String, Properties> entry : resources.entrySet()) {
            services.add(new Service(bundle, entry.getKey(), entry.getValue()));
        }
        this.startServers(bundle, services);
    }

    @Override
    public synchronized void stop() {
        if (this.started == Boolean.TRUE) {
            this.started = Boolean.FALSE;
            for (Map.Entry<Bundle, List<Service>> entry : this.serverMap.entrySet()) {
                for (Service service : entry.getValue()) {
                    service.stop();
                }
            }
        }
    }

    protected synchronized void removedServers(Bundle bundle) {
        List<Service> services = this.serverMap.remove(bundle);
        if (services != null) {
            for (Service service : services) {
                service.stop();
            }
        }
    }

    protected void shutdown() {
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.stop();
    }

    private class ServerServiceTracker
    implements BundleTrackerCustomizer {
        private ServerServiceTracker() {
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            return this.scan(bundle);
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object arg2) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object arg2) {
            ServiceManagerExtender.this.removedServers(bundle);
        }

        private Object scan(Bundle bundle) {
            String basePath = "/META-INF/" + ServerService.class.getName() + "/";
            Enumeration entries = bundle.findEntries(basePath, "*", false);
            if (entries != null) {
                HashMap<String, Properties> resources = new HashMap<String, Properties>();
                while (entries.hasMoreElements()) {
                    URL entry = (URL)entries.nextElement();
                    String name = entry.getPath().substring(basePath.length());
                    try {
                        Properties props = this.loadProperties(entry);
                        this.setClass(props, bundle, ServerService.class);
                        this.setRawProperties(props, entry);
                        resources.put(name, props);
                    }
                    catch (Exception e) {
                        logger.error("Error loading " + name + " properties", (Throwable)e);
                    }
                }
                ServiceManagerExtender.this.addedServers(bundle, resources);
                return bundle;
            }
            return null;
        }

        private void setClass(Properties properties, Bundle bundle, Class interfase) throws ClassNotFoundException {
            String className = properties.getProperty("className");
            if (className == null && (className = properties.getProperty("classname")) == null) {
                className = properties.getProperty("server");
            }
            Class impl = bundle.loadClass(className);
            properties.put(interfase, impl);
        }

        private void setRawProperties(Properties properties, URL entry) throws IOException {
            String rawProperties = this.readContents(entry);
            properties.put(Properties.class, rawProperties);
        }

        private Properties loadProperties(URL resource) throws IOException {
            return IO.readProperties((URL)resource);
        }

        private String readContents(URL resource) throws IOException {
            return IO.slurp((URL)resource);
        }
    }

    private class Service {
        private final String name;
        private final Properties description;
        private final Bundle bundle;
        private ServiceRegistration registration;
        private ServerService server;

        public Service(Bundle bundle, String name, Properties description) {
            this.bundle = bundle;
            this.name = name;
            this.description = description;
        }

        public void start() {
            try {
                this.server = ServiceManagerExtender.this.initServer(this.name, this.description);
            }
            catch (IOException e) {
                logger.error("Error initializing " + this.name + " service.", (Throwable)e);
            }
            if (this.server != null) {
                try {
                    this.server.start();
                }
                catch (Exception e) {
                    logger.error("Service Start Failed: " + this.name + " " + this.server.getIP() + " " + this.server.getPort() + ". Exception: " + e.getMessage(), (Throwable)e);
                }
                BundleContext context = this.bundle.getBundleContext();
                this.registration = context.registerService(ServerService.class.getName(), (Object)this.server, (Dictionary)this.getServiceProperties());
            }
        }

        private Hashtable getServiceProperties() {
            Hashtable<Object, Object> props = new Hashtable<Object, Object>();
            for (Map.Entry<Object, Object> entry : this.description.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                props.put(entry.getKey(), entry.getValue());
            }
            return props;
        }

        public void stop() {
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                catch (Exception e) {
                    logger.warning("Service Shutdown Failed: " + this.name + ". Exception: " + e.getMessage(), (Throwable)e);
                }
            }
            if (this.registration != null) {
                try {
                    this.registration.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

