/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.ejb;

import jakarta.interceptor.InvocationContext;
import jakarta.xml.ws.WebFault;
import jakarta.xml.ws.handler.MessageContext;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.MessageContentsList;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.server.cxf.ejb.EjbInterceptor;
import org.apache.openejb.server.cxf.ejb.EjbMessageContext;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class EjbMethodInvoker
extends AbstractJAXWSMethodInvoker {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.CXF, EjbMethodInvoker.class);
    private static final String HANDLER_PROPERTIES = "HandlerProperties";
    private final Object instance;
    private final BeanContext beanContext;
    private final Bus bus;

    public EjbMethodInvoker(Bus bus, BeanContext beanContext) {
        super(null);
        Object inst;
        this.bus = bus;
        this.beanContext = beanContext;
        try {
            inst = beanContext.getBeanClass().newInstance();
        }
        catch (Exception e) {
            inst = null;
        }
        this.instance = inst;
    }

    public Object getServiceObject(Exchange context) {
        return this.instance;
    }

    public void releaseServiceObject(Exchange ex, Object obj) {
    }

    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        InvocationContext invContext = (InvocationContext)exchange.get(InvocationContext.class);
        if (invContext == null) {
            return this.preEjbInvoke(exchange, m, params);
        }
        return super.invoke(exchange, serviceObject, m, params);
    }

    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        InvocationContext invContext = (InvocationContext)exchange.get(InvocationContext.class);
        invContext.setParameters(paramArray);
        Object res = invContext.proceed();
        EjbMessageContext ctx = (EjbMessageContext)((Object)invContext.getContextData());
        Map handlerProperties = (Map)exchange.get((Object)HANDLER_PROPERTIES);
        this.addHandlerProperties(ctx, handlerProperties);
        this.updateWebServiceContext(exchange, (MessageContext)ctx);
        return res;
    }

    private Object preEjbInvoke(Exchange exchange, Method method, List<Object> params) {
        EjbMessageContext ctx = new EjbMessageContext(exchange.getInMessage(), MessageContext.Scope.APPLICATION);
        WebServiceContextImpl.setMessageContext((MessageContext)ctx);
        Map handlerProperties = this.removeHandlerProperties(ctx);
        exchange.put((Object)HANDLER_PROPERTIES, (Object)handlerProperties);
        try {
            EjbInterceptor interceptor = new EjbInterceptor(params, method, this.bus, exchange);
            Object[] arguments = new Object[]{ctx, interceptor};
            RpcContainer container = (RpcContainer)this.beanContext.getContainer();
            Class callInterface = this.beanContext.getServiceEndpointInterface();
            method = this.getMostSpecificMethod(this.beanContext, method, callInterface);
            Object res = container.invoke(this.beanContext.getDeploymentID(), InterfaceType.SERVICE_ENDPOINT, callInterface, method, arguments, null);
            if (exchange.isOneWay()) {
                Object var11_13 = null;
                return var11_13;
            }
            MessageContentsList messageContentsList = new MessageContentsList(new Object[]{res});
            return messageContentsList;
        }
        catch (ApplicationException e) {
            Throwable t = e.getCause();
            if (t != null) {
                if (RuntimeException.class.isAssignableFrom(t.getClass()) && t.getClass().isAnnotationPresent(jakarta.ejb.ApplicationException.class)) {
                    throw (RuntimeException)t;
                }
                if (!t.getClass().isAnnotationPresent(WebFault.class)) {
                    exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
                    throw this.createFault(t, method, params, false);
                }
            } else {
                t = e;
            }
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw this.createFault(t, method, params, false);
        }
        catch (Exception e) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw this.createFault(e, method, params, false);
        }
        finally {
            WebServiceContextImpl.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getMostSpecificMethod(BeanContext beanContext, Method method, Class callInterface) {
        MostSpecificMethodKey key;
        Method m;
        MostSpecificMethodCache cache = (MostSpecificMethodCache)beanContext.get(MostSpecificMethodCache.class);
        if (cache == null) {
            BeanContext beanContext2 = beanContext;
            synchronized (beanContext2) {
                cache = (MostSpecificMethodCache)beanContext.get(MostSpecificMethodCache.class);
                if (cache == null) {
                    cache = new MostSpecificMethodCache();
                    beanContext.set(MostSpecificMethodCache.class, (Object)cache);
                }
            }
        }
        if ((m = (Method)cache.methods.get(key = new MostSpecificMethodKey(callInterface, method))) == null) {
            m = EjbMethodInvoker.getMostSpecificMethod((Method)method, (Class)callInterface);
            cache.methods.putIfAbsent(key, m);
        }
        return m;
    }

    public Object directEjbInvoke(Exchange exchange, Method m, List<Object> params) throws Exception {
        Object[] paramArray = params != null ? params.toArray() : new Object[]{};
        return this.performInvocation(exchange, null, m, paramArray);
    }

    public static class MostSpecificMethodCache {
        public final ConcurrentMap<MostSpecificMethodKey, Method> methods = new ConcurrentHashMap<MostSpecificMethodKey, Method>();
    }

    public static class MostSpecificMethodKey {
        public final Class<?> ejbInterface;
        public final Method method;
        private int hashCode;

        public MostSpecificMethodKey(Class<?> ejbInterface, Method method) {
            this.ejbInterface = ejbInterface;
            this.method = method;
            this.hashCode = ejbInterface != null ? ejbInterface.hashCode() : 0;
            this.hashCode = 31 * this.hashCode + (method != null ? method.hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MostSpecificMethodKey that = (MostSpecificMethodKey)o;
            return !(this.ejbInterface == null ? that.ejbInterface != null : !this.ejbInterface.equals(that.ejbInterface)) && !(this.method == null ? that.method != null : !this.method.equals(that.method));
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

