/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;

public class DiscoveryRegistry
implements DiscoveryListener,
DiscoveryAgent {
    private final List<DiscoveryAgent> agents = new CopyOnWriteArrayList<DiscoveryAgent>();
    private final List<DiscoveryListener> listeners = new CopyOnWriteArrayList<DiscoveryListener>();
    private final Map<String, URI> services = new ConcurrentHashMap<String, URI>();
    private final Map<String, URI> registered = new ConcurrentHashMap<String, URI>();
    @Managed
    private final Monitor monitor = new Monitor();
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runable) {
            Thread t = new Thread(runable, DiscoveryRegistry.class.getSimpleName());
            t.setDaemon(true);
            return t;
        }
    });

    public DiscoveryRegistry() {
        this(null);
    }

    public DiscoveryRegistry(DiscoveryAgent agent) {
        this.executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
                if (null == r || null == tpe || tpe.isShutdown() || tpe.isTerminated() || tpe.isTerminating()) {
                    return;
                }
                try {
                    tpe.getQueue().offer(r, 20L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        SystemInstance.get().setComponent(DiscoveryRegistry.class, (Object)this);
        SystemInstance.get().setComponent(DiscoveryAgent.class, (Object)this);
        if (null != agent) {
            this.addDiscoveryAgent(agent);
        }
    }

    public void addDiscoveryAgent(DiscoveryAgent agent) {
        this.agents.add(agent);
        agent.setDiscoveryListener(this);
        for (URI uri : this.registered.values()) {
            try {
                agent.registerService(uri);
            }
            catch (Exception exception) {}
        }
    }

    public Set<URI> getServices() {
        return new HashSet<URI>(this.services.values());
    }

    @Override
    public void registerService(URI serviceUri) throws IOException {
        this.registered.put(serviceUri.toString(), serviceUri);
        for (DiscoveryAgent agent : this.agents) {
            agent.registerService(serviceUri);
        }
    }

    @Override
    public void reportFailed(URI serviceUri) throws IOException {
        this.registered.remove(serviceUri.toString());
        for (DiscoveryAgent agent : this.agents) {
            agent.reportFailed(serviceUri);
        }
    }

    @Override
    public void unregisterService(URI serviceUri) throws IOException {
        this.registered.remove(serviceUri.toString());
        for (DiscoveryAgent agent : this.agents) {
            agent.unregisterService(serviceUri);
        }
    }

    @Override
    public void setDiscoveryListener(DiscoveryListener listener) {
        this.addDiscoveryListener(listener);
    }

    public void addDiscoveryListener(DiscoveryListener listener) {
        for (URI service : this.services.values()) {
            this.executor.execute(new ServiceAddedTask(listener, service));
        }
        this.listeners.add(listener);
    }

    public void removeDiscoveryListener(DiscoveryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void serviceAdded(URI service) {
        this.services.put(service.toString(), service);
        for (DiscoveryListener discoveryListener : this.getListeners()) {
            this.executor.execute(new ServiceAddedTask(discoveryListener, service));
        }
    }

    @Override
    public void serviceRemoved(URI service) {
        this.services.remove(service.toString());
        for (DiscoveryListener discoveryListener : this.getListeners()) {
            this.executor.execute(new ServiceRemovedTask(discoveryListener, service));
        }
    }

    List<DiscoveryListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Managed
    private class Monitor {
        private Monitor() {
        }

        @Managed
        public String[] getDiscovered() {
            Set<String> set = DiscoveryRegistry.this.services.keySet();
            return set.toArray(new String[set.size()]);
        }

        @Managed
        public String[] getRegistered() {
            Set<String> set = DiscoveryRegistry.this.registered.keySet();
            return set.toArray(new String[set.size()]);
        }

        @Managed
        public String[] getAgents() {
            ArrayList<String> list = new ArrayList<String>();
            for (DiscoveryAgent agent : DiscoveryRegistry.this.agents) {
                list.add(agent.getClass().getName());
            }
            return list.toArray(new String[list.size()]);
        }
    }

    private static class ServiceAddedTask
    extends Task {
        public ServiceAddedTask(DiscoveryListener discoveryListener, URI service) {
            super(discoveryListener, service);
        }

        @Override
        public void run() {
            if (this.discoveryListener != null) {
                this.discoveryListener.serviceAdded(this.service);
            }
        }
    }

    private static class ServiceRemovedTask
    extends Task {
        public ServiceRemovedTask(DiscoveryListener discoveryListener, URI service) {
            super(discoveryListener, service);
        }

        @Override
        public void run() {
            if (this.discoveryListener != null) {
                this.discoveryListener.serviceRemoved(this.service);
            }
        }
    }

    private static abstract class Task
    implements Runnable {
        protected final DiscoveryListener discoveryListener;
        protected final URI service;

        protected Task(DiscoveryListener discoveryListener, URI service) {
            this.discoveryListener = discoveryListener;
            this.service = service;
        }
    }
}

