/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices.saaj;

import java.util.LinkedList;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class SaajUniverse {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_WS, SaajUniverse.class);
    public static final Type DEFAULT;
    public static final Type SUN;
    public static final Type AXIS2;
    private static final ThreadLocal<LinkedList<Type>> CURRENT_UNIVERSE;

    private static void setProperty(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    public void set(Type newUniverse) {
        LinkedList<Type> universeList = CURRENT_UNIVERSE.get();
        universeList.add(newUniverse);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set universe: " + Thread.currentThread() + " " + newUniverse);
        }
    }

    public void unset() {
        LinkedList<Type> universeList = CURRENT_UNIVERSE.get();
        if (universeList != null && !universeList.isEmpty()) {
            universeList.removeLast();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Restored universe: " + Thread.currentThread());
            }
        }
    }

    static Type getCurrentUniverse() {
        LinkedList<Type> universeList = CURRENT_UNIVERSE.get();
        if (universeList != null && !universeList.isEmpty()) {
            return universeList.getLast();
        }
        return null;
    }

    static {
        if (SystemInstance.get().getOptions().get("openejb.soap.override-factory", false)) {
            SaajUniverse.setProperty("jakarta.xml.soap.MessageFactory", "org.apache.openejb.server.webservices.saaj.MessageFactoryImpl");
            SaajUniverse.setProperty("jakarta.xml.soap.SOAPFactory", "org.apache.openejb.server.webservices.saaj.SoapFactoryImpl");
            SaajUniverse.setProperty("jakarta.xml.soap.SOAPConnectionFactory", "org.apache.openejb.server.webservices.saaj.SoapConnectionFactoryImpl");
            SaajUniverse.setProperty("jakarta.xml.soap.MetaFactory", "org.apache.openejb.server.webservices.saaj.SaajMetaFactoryImpl");
        }
        DEFAULT = Type.DEFAULT;
        SUN = Type.SUN;
        AXIS2 = Type.AXIS2;
        CURRENT_UNIVERSE = new ThreadLocal<LinkedList<Type>>(){

            @Override
            protected LinkedList<Type> initialValue() {
                return new LinkedList<Type>();
            }
        };
    }

    static enum Type {
        DEFAULT,
        AXIS2,
        SUN;

    }
}

