/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.querybuilders.core;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.DateRangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.NumberRangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.TermRangeQuery;
import co.elastic.clients.util.ObjectBuilder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.unomi.api.GeoPoint;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilderDispatcher;
import org.apache.unomi.persistence.spi.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.spi.conditions.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class PropertyConditionESQueryBuilder
implements ConditionESQueryBuilder {
    private final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
    private static final Set<String> EQUALITY_OPERATORS = Set.of("equals", "notEquals");
    private static final Set<String> COMPARISON_OPERATORS = Set.of("greaterThan", "lessThanOrEqualTo", "lessThan", "greaterThanOrEqualTo");
    private static final Set<String> EXISTENCE_OPERATORS = Set.of("exists", "missing");
    private static final Set<String> CONTENT_OPERATORS = Set.of("contains", "notContains", "startsWith", "endsWith", "matchesRegex");
    private static final Set<String> COLLECTION_OPERATORS = Set.of("in", "notIn", "all", "inContains", "hasSomeOf", "hasNoneOf");
    private static final Set<String> DATE_OPERATORS = Set.of("isDay", "isNotDay");

    @Override
    public Query buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        String comparisonOperator = (String)condition.getParameter("comparisonOperator");
        String propertyName = (String)condition.getParameter("propertyName");
        this.validateRequiredParameters(comparisonOperator, propertyName);
        PropertyValues propertyValues = this.extractPropertyValues(condition);
        if (EQUALITY_OPERATORS.contains(comparisonOperator)) {
            return this.buildEqualityQuery(propertyName, propertyValues.singleValue, comparisonOperator);
        }
        if (COMPARISON_OPERATORS.contains(comparisonOperator)) {
            return this.buildComparisonQuery(propertyName, propertyValues.singleValue, comparisonOperator);
        }
        if (comparisonOperator.equals("between")) {
            return this.buildBetweenQuery(propertyName, propertyValues.multipleValues);
        }
        if (EXISTENCE_OPERATORS.contains(comparisonOperator)) {
            return this.buildExistenceQuery(propertyName, comparisonOperator);
        }
        if (CONTENT_OPERATORS.contains(comparisonOperator)) {
            return this.buildContentQuery(propertyName, (String)propertyValues.singleValue, comparisonOperator);
        }
        if (COLLECTION_OPERATORS.contains(comparisonOperator)) {
            return this.buildCollectionQuery(propertyName, propertyValues.multipleValues, comparisonOperator);
        }
        if (DATE_OPERATORS.contains(comparisonOperator)) {
            return this.buildDateQuery(propertyName, propertyValues.singleValue, comparisonOperator);
        }
        if (comparisonOperator.equals("distance")) {
            return this.buildDistanceQuery(condition, propertyName);
        }
        return null;
    }

    private PropertyValues extractPropertyValues(Condition condition) {
        String stringValue = ConditionContextHelper.forceFoldToASCII((Object)condition.getParameter("propertyValue"));
        Object integerValue = condition.getParameter("propertyValueInteger");
        Object doubleValue = condition.getParameter("propertyValueDouble");
        Object dateValue = this.convertDateToISO(condition.getParameter("propertyValueDate"));
        Object dateExprValue = condition.getParameter("propertyValueDateExpr");
        Collection stringValues = ConditionContextHelper.forceFoldToASCII((Collection)((Collection)condition.getParameter("propertyValues")));
        Collection integerValues = (Collection)condition.getParameter("propertyValuesInteger");
        Collection doubleValues = (Collection)condition.getParameter("propertyValuesDouble");
        Collection<?> dateValues = this.convertDatesToISO((Collection)condition.getParameter("propertyValuesDate"));
        Collection dateExprValues = (Collection)condition.getParameter("propertyValuesDateExpr");
        Object singleValue = ObjectUtils.firstNonNull((Object[])new Object[]{stringValue, integerValue, doubleValue, dateValue, dateExprValue});
        Collection multipleValues = (Collection)ObjectUtils.firstNonNull((Object[])new Collection[]{stringValues, integerValues, doubleValues, dateValues, dateExprValues});
        return new PropertyValues(singleValue, multipleValues);
    }

    private void validateRequiredParameters(String comparisonOperator, String propertyName) {
        if (comparisonOperator == null || propertyName == null) {
            throw new IllegalArgumentException("Cannot build ES query, the condition is not valid: comparisonOperator and propertyName properties are required");
        }
    }

    private void checkRequiredValue(Object value, String name, String operator, boolean multiple) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot build ES query, missing value" + (multiple ? "s" : "") + " for condition using operator: " + operator + " and property: " + name);
        }
    }

    private void checkRequiredValuesSize(Collection<?> values, String name, String operator, int expectedSize) {
        if (values == null || values.size() != expectedSize) {
            throw new IllegalArgumentException("Cannot build ES query, missing " + expectedSize + " values for a condition using operator: " + operator + " and property: " + name);
        }
    }

    private Query buildEqualityQuery(String propertyName, Object value, String operator) {
        this.checkRequiredValue(value, propertyName, operator, false);
        if (operator.equals("equals")) {
            return Query.of(q -> q.term(t -> t.field(propertyName).value(v -> this.getValue(value))));
        }
        return Query.of(q -> q.bool(b -> b.mustNot(m -> m.term(t -> t.field(propertyName).value(v -> this.getValue(value))))));
    }

    private Query buildComparisonQuery(String propertyName, Object value, String operator) {
        this.checkRequiredValue(value, propertyName, operator, false);
        return Query.of(q -> q.range(this.getRangeQuery(propertyName, value, operator)));
    }

    private Query buildBetweenQuery(String propertyName, Collection<?> values) {
        this.checkRequiredValuesSize(values, propertyName, "between", 2);
        return Query.of(q -> q.range(this.getRangeQuery(propertyName, values, "between")));
    }

    private Query buildExistenceQuery(String propertyName, String operator) {
        if (operator.equals("exists")) {
            return Query.of(q -> q.exists(e -> e.field(propertyName)));
        }
        return Query.of(q -> q.bool(b -> b.mustNot(m -> m.exists(e -> e.field(propertyName)))));
    }

    private Query buildContentQuery(String propertyName, String value, String operator) {
        this.checkRequiredValue(value, propertyName, operator, false);
        return switch (operator) {
            case "contains" -> Query.of(q -> q.regexp(r -> r.field(propertyName).value(".*" + value + ".*")));
            case "notContains" -> Query.of(q -> q.bool(b -> b.mustNot(m -> m.regexp(r -> r.field(propertyName).value(".*" + value + ".*")))));
            case "startsWith" -> Query.of(q -> q.prefix(p -> p.field(propertyName).value(value)));
            case "endsWith" -> Query.of(q -> q.regexp(r -> r.field(propertyName).value(".*" + value)));
            case "matchesRegex" -> Query.of(q -> q.regexp(r -> r.field(propertyName).value(value)));
            default -> throw new IllegalArgumentException("Unsupported content operator: " + operator);
        };
    }

    private Query buildCollectionQuery(String propertyName, Collection<?> values, String operator) {
        this.checkRequiredValue(values, propertyName, operator, true);
        return switch (operator) {
            case "in" -> Query.of(q -> q.terms(t -> t.field(propertyName).terms(t2 -> t2.value(this.getValues(values)))));
            case "notIn" -> Query.of(q -> q.bool(b -> b.mustNot(m -> m.terms(t -> t.field(propertyName).terms(t2 -> t2.value(this.getValues(values)))))));
            case "all" -> {
                BoolQuery.Builder all = new BoolQuery.Builder();
                for (Object curValue : values) {
                    all.must(Query.of(q -> q.term(t -> t.field(propertyName).value(this.getValue(curValue).build()))), new Query[0]);
                }
                yield Query.of(q -> q.bool(all.build()));
            }
            case "inContains" -> {
                BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
                for (Object curValue : values) {
                    boolQueryBuilder.must(Query.of(q -> q.regexp(r -> r.field(propertyName).value(".*" + String.valueOf(curValue) + ".*"))), new Query[0]);
                }
                yield Query.of(q -> q.bool(boolQueryBuilder.build()));
            }
            case "hasSomeOf" -> {
                BoolQuery.Builder hasSomeOf = new BoolQuery.Builder();
                for (Object curValue : values) {
                    hasSomeOf.should(Query.of(q -> q.term(t -> t.field(propertyName).value(this.getValue(curValue).build()))), new Query[0]);
                }
                yield Query.of(q -> q.bool(hasSomeOf.build()));
            }
            case "hasNoneOf" -> {
                BoolQuery.Builder hasNoneOf = new BoolQuery.Builder();
                for (Object curValue : values) {
                    hasNoneOf.mustNot(Query.of(q -> q.term(t -> t.field(propertyName).value(this.getValue(curValue).build()))), new Query[0]);
                }
                yield Query.of(q -> q.bool(hasNoneOf.build()));
            }
            default -> throw new IllegalArgumentException("Unsupported collection operator: " + operator);
        };
    }

    private Query buildDateQuery(String propertyName, Object value, String operator) {
        this.checkRequiredValue(value, propertyName, operator, false);
        if (operator.equals("isDay")) {
            return this.getIsSameDayRange(DateUtils.getDate((Object)value), propertyName);
        }
        return Query.of(q -> q.bool(b -> b.mustNot(this.getIsSameDayRange(DateUtils.getDate((Object)value), propertyName), new Query[0])));
    }

    private Query buildDistanceQuery(Condition condition, String propertyName) {
        String unitString = (String)condition.getParameter("unit");
        Object centerObj = condition.getParameter("center");
        Double distance = (Double)condition.getParameter("distance");
        if (centerObj == null || distance == null) {
            throw new IllegalArgumentException("The 'center' and 'distance' parameters are required for the distance operator");
        }
        String centerString = centerObj instanceof GeoPoint ? ((GeoPoint)centerObj).asString() : (centerObj instanceof String ? (String)centerObj : centerObj.toString());
        GeoDistanceType unit = unitString != null ? GeoDistanceType.valueOf(unitString) : GeoDistanceType.Plane;
        return Query.of(q -> q.geoDistance(g -> g.field(propertyName).distance("" + distance).distanceType(unit).location(l -> l.text(centerString))));
    }

    private Query getIsSameDayRange(Date value, String name) {
        DateTime date = new DateTime((Object)value);
        DateTime dayStart = date.withTimeAtStartOfDay();
        DateTime dayAfterStart = date.plusDays(1).withTimeAtStartOfDay();
        return DateRangeQuery.of(d -> (ObjectBuilder)((DateRangeQuery.Builder)d.field(name).gte(dayStart.toString())).lt(dayAfterStart.toString()))._toRangeQuery()._toQuery();
    }

    private Object convertDateToISO(Object dateValue) {
        if (dateValue == null) {
            return null;
        }
        if (dateValue instanceof Date) {
            return this.dateTimeFormatter.print((ReadableInstant)new DateTime(dateValue));
        }
        if (dateValue instanceof OffsetDateTime) {
            return this.dateTimeFormatter.print((ReadableInstant)new DateTime((Object)Date.from(((OffsetDateTime)dateValue).toInstant())));
        }
        return dateValue;
    }

    private Collection<?> convertDatesToISO(Collection<?> datesValues) {
        if (datesValues == null) {
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>(datesValues.size());
        for (Object dateValue : datesValues) {
            if (dateValue == null) continue;
            results.add(this.convertDateToISO(dateValue));
        }
        return results;
    }

    private RangeQuery getRangeQuery(String fieldName, Object value, String comparisonOperator) {
        if (value instanceof String) {
            return new RangeQuery.Builder().term(t -> this.withComparison(t.field(fieldName), (String)value, comparisonOperator)).build();
        }
        if (value instanceof Date) {
            return new RangeQuery.Builder().date(t -> this.withComparison(t.field(fieldName), this.convertDateToISO(value).toString(), comparisonOperator)).build();
        }
        if (value instanceof Number) {
            return new RangeQuery.Builder().number(t -> this.withComparison(t.field(fieldName), ((Number)value).doubleValue(), comparisonOperator)).build();
        }
        if (value instanceof Collection) {
            Iterator iterator = ((Collection)value).iterator();
            Object val1 = iterator.next();
            Object val2 = iterator.next();
            if (val1 instanceof String) {
                return new RangeQuery.Builder().term(t -> (ObjectBuilder)((TermRangeQuery.Builder)t.field(fieldName).gte((String)val1)).lte((String)val2)).build();
            }
            if (val1 instanceof Date) {
                return new RangeQuery.Builder().date(t -> (ObjectBuilder)((DateRangeQuery.Builder)t.field(fieldName).gte(this.convertDateToISO(val1).toString())).lte(this.convertDateToISO(val2).toString())).build();
            }
            if (val1 instanceof Number) {
                return new RangeQuery.Builder().number(t -> (ObjectBuilder)((NumberRangeQuery.Builder)t.field(fieldName).gte(((Number)val1).doubleValue())).lte(((Number)val2).doubleValue())).build();
            }
        }
        throw new IllegalArgumentException("Unsupported value type for range query: " + (value != null ? value.getClass().getName() : "null"));
    }

    private <K, T extends RangeQueryBase.AbstractBuilder<K, T>> T withComparison(RangeQueryBase.AbstractBuilder<K, T> range, K value, String comparisonOperator) {
        return switch (comparisonOperator) {
            case "greaterThan" -> range.gt(value);
            case "greaterThanOrEqualTo" -> range.gte(value);
            case "lessThan" -> range.lt(value);
            case "lessThanOrEqualTo" -> range.lte(value);
            default -> throw new IllegalArgumentException("Unsupported comparison operator for range query: " + comparisonOperator);
        };
    }

    private ObjectBuilder<FieldValue> getValue(Object fieldValue) {
        FieldValue.Builder fieldValueBuilder = new FieldValue.Builder();
        if (fieldValue instanceof String) {
            return fieldValueBuilder.stringValue((String)fieldValue);
        }
        if (fieldValue instanceof Integer) {
            return fieldValueBuilder.longValue(((Integer)fieldValue).intValue());
        }
        if (fieldValue instanceof Long) {
            return fieldValueBuilder.longValue((Long)fieldValue);
        }
        if (fieldValue instanceof Double) {
            return fieldValueBuilder.doubleValue((Double)fieldValue);
        }
        if (fieldValue instanceof Float) {
            return fieldValueBuilder.doubleValue(((Float)fieldValue).floatValue());
        }
        if (fieldValue instanceof Boolean) {
            return fieldValueBuilder.booleanValue((Boolean)fieldValue);
        }
        if (fieldValue instanceof Date || fieldValue instanceof OffsetDateTime) {
            return fieldValueBuilder.stringValue(this.convertDateToISO(fieldValue).toString());
        }
        throw new IllegalArgumentException("Unsupported value type: " + (fieldValue != null ? fieldValue.getClass().getName() : "null"));
    }

    private List<FieldValue> getValues(Collection<?> fieldValues) {
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(fieldValues.size());
        for (Object fieldValue : fieldValues) {
            values.add(this.getValue(fieldValue).build());
        }
        return values;
    }

    private static class PropertyValues {
        final Object singleValue;
        final Collection<?> multipleValues;

        PropertyValues(Object singleValue, Collection<?> multipleValues) {
            this.singleValue = singleValue;
            this.multipleValues = multipleValues;
        }
    }
}

