/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.scripting;

import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExpressionFilter.class.getName());
    private final Set<Pattern> allowedExpressionPatterns;
    private final Set<Pattern> forbiddenExpressionPatterns;

    public ExpressionFilter(Set<Pattern> allowedExpressionPatterns, Set<Pattern> forbiddenExpressionPatterns) {
        this.allowedExpressionPatterns = allowedExpressionPatterns;
        this.forbiddenExpressionPatterns = forbiddenExpressionPatterns;
    }

    public String filter(String expression) {
        if (this.forbiddenExpressionPatterns != null && this.expressionMatches(expression, this.forbiddenExpressionPatterns)) {
            LOGGER.warn("Expression filtered because forbidden. See debug log level for more information");
            LOGGER.debug("Expression {} is forbidden by expression filter", (Object)expression);
            return null;
        }
        if (this.allowedExpressionPatterns != null && !this.expressionMatches(expression, this.allowedExpressionPatterns)) {
            LOGGER.warn("Expression filtered because not allowed. See debug log level for more information");
            LOGGER.debug("Expression {} is not allowed by expression filter", (Object)expression);
            return null;
        }
        return expression;
    }

    private boolean expressionMatches(String expression, Set<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(expression).matches()) continue;
            return true;
        }
        return false;
    }
}

