/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeConfiguration;

public abstract class AMQPBridgeLinkConfiguration {
    protected final Map<String, Object> properties;
    protected final AMQPBridgeConfiguration configuration;

    public AMQPBridgeLinkConfiguration(AMQPBridgeConfiguration configuration, Map<String, ?> properties) {
        Objects.requireNonNull(configuration, "Bridge configuration cannot be null");
        this.configuration = configuration;
        this.properties = properties == null || properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(properties));
    }

    public final int getLinkAttachTimeout() {
        Object property = this.properties.get("attach-timeout");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getLinkAttachTimeout();
    }

    public final boolean isUsingPresettledSenders() {
        Object property = this.properties.get("presettle");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isUsingPresettledSenders();
    }

    public final boolean isLinkRecoveryEnabled() {
        return this.getMaxLinkRecoveryAttempts() != 0;
    }

    public final int getMaxLinkRecoveryAttempts() {
        Object property = this.properties.get("maxLinkRecoveryAttempts");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getMaxLinkRecoveryAttempts();
    }

    public final long getLinkRecoveryInitialDelay() {
        Object property = this.properties.get("linkRecoveryInitialDelay");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getLinkRecoveryInitialDelay();
    }

    public final long getLinkRecoveryDelay() {
        Object property = this.properties.get("linkRecoveryDelay");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getLinkRecoveryDelay();
    }

    public boolean isCoreMessageTunnelingEnabled() {
        Object property = this.properties.get("tunnel-core-messages");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isCoreMessageTunnelingEnabled();
    }
}

