/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import io.opentelemetry.semconv.JvmAttributes;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class Threads {
    static final Threads INSTANCE;
    @Nullable
    private static final MethodHandle THREAD_INFO_IS_DAEMON;

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return INSTANCE.registerObservers(openTelemetry, Threads.useThreads());
    }

    private List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, boolean useThread) {
        if (useThread) {
            return this.registerObservers(openTelemetry, Threads::getThreads);
        }
        return this.registerObservers(openTelemetry, ManagementFactory.getThreadMXBean());
    }

    List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, ThreadMXBean threadBean) {
        return Threads.registerObservers(openTelemetry, Threads.isJava9OrNewer() ? Threads::java9AndNewerCallback : Threads::java8Callback, threadBean);
    }

    List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, Supplier<Thread[]> threadSupplier) {
        return Threads.registerObservers(openTelemetry, Threads::java8ThreadCallback, threadSupplier);
    }

    private static <T> List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, Function<T, Consumer<ObservableLongMeasurement>> callbackProvider, T threadInfo) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.thread.count").setDescription("Number of executing platform threads.").setUnit("{thread}").buildWithCallback(callbackProvider.apply(threadInfo)));
        return observables;
    }

    private static boolean isJava9OrNewer() {
        return THREAD_INFO_IS_DAEMON != null;
    }

    private static boolean useThreads() {
        boolean isNativeExecution = System.getProperty("org.graalvm.nativeimage.imagecode") != null;
        return !Threads.isJava9OrNewer() || isNativeExecution;
    }

    private static Consumer<ObservableLongMeasurement> java8Callback(ThreadMXBean threadBean) {
        return measurement -> {
            int daemonThreadCount = threadBean.getDaemonThreadCount();
            measurement.record((long)daemonThreadCount, Attributes.builder().put(JvmAttributes.JVM_THREAD_DAEMON, (Object)true).build());
            measurement.record((long)(threadBean.getThreadCount() - daemonThreadCount), Attributes.builder().put(JvmAttributes.JVM_THREAD_DAEMON, (Object)false).build());
        };
    }

    private static Consumer<ObservableLongMeasurement> java8ThreadCallback(Supplier<Thread[]> supplier) {
        return measurement -> {
            HashMap<Attributes, Long> counts = new HashMap<Attributes, Long>();
            for (Thread thread : (Thread[])supplier.get()) {
                Attributes threadAttributes2 = Threads.threadAttributes(thread);
                counts.compute(threadAttributes2, (k, value) -> value == null ? 1L : value + 1L);
            }
            counts.forEach((threadAttributes, count) -> measurement.record(count.longValue(), threadAttributes));
        };
    }

    static Thread[] getThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        int count = threadGroup.activeCount() + 10;
        Thread[] threads = new Thread[count];
        int resultSize = threadGroup.enumerate(threads);
        if (resultSize == threads.length) {
            return threads;
        }
        Thread[] result = new Thread[resultSize];
        System.arraycopy(threads, 0, result, 0, resultSize);
        return result;
    }

    private static Consumer<ObservableLongMeasurement> java9AndNewerCallback(ThreadMXBean threadBean) {
        return measurement -> {
            HashMap<Attributes, Long> counts = new HashMap<Attributes, Long>();
            long[] threadIds = threadBean.getAllThreadIds();
            for (ThreadInfo threadInfo : threadBean.getThreadInfo(threadIds)) {
                if (threadInfo == null) continue;
                Attributes threadAttributes2 = Threads.threadAttributes(threadInfo);
                counts.compute(threadAttributes2, (k, value) -> value == null ? 1L : value + 1L);
            }
            counts.forEach((threadAttributes, count) -> measurement.record(count.longValue(), threadAttributes));
        };
    }

    private static Attributes threadAttributes(ThreadInfo threadInfo) {
        boolean isDaemon;
        try {
            isDaemon = Objects.requireNonNull(THREAD_INFO_IS_DAEMON).invoke(threadInfo);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unexpected error happened during ThreadInfo#isDaemon()", e);
        }
        String threadState = threadInfo.getThreadState().name().toLowerCase(Locale.ROOT);
        return Attributes.of((AttributeKey)JvmAttributes.JVM_THREAD_DAEMON, (Object)isDaemon, (AttributeKey)JvmAttributes.JVM_THREAD_STATE, (Object)threadState);
    }

    private static Attributes threadAttributes(Thread thread) {
        boolean isDaemon = thread.isDaemon();
        String threadState = thread.getState().name().toLowerCase(Locale.ROOT);
        return Attributes.of((AttributeKey)JvmAttributes.JVM_THREAD_DAEMON, (Object)isDaemon, (AttributeKey)JvmAttributes.JVM_THREAD_STATE, (Object)threadState);
    }

    private Threads() {
    }

    static {
        MethodHandle isDaemon;
        INSTANCE = new Threads();
        try {
            isDaemon = MethodHandles.publicLookup().findVirtual(ThreadInfo.class, "isDaemon", MethodType.methodType(Boolean.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            isDaemon = null;
        }
        THREAD_INFO_IS_DAEMON = isDaemon;
    }
}

