/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class MaxSSTableSizeWriter
extends CompactionAwareWriter {
    private final long maxSSTableSize;
    private final int level;
    private final long estimatedSSTables;

    public MaxSSTableSizeWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, int level) {
        this(cfs, directories, txn, nonExpiredSSTables, maxSSTableSize, level, false);
    }

    public MaxSSTableSizeWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, int level, boolean keepOriginals) {
        super(cfs, directories, txn, nonExpiredSSTables, keepOriginals);
        this.level = level;
        this.maxSSTableSize = maxSSTableSize;
        long totalSize = MaxSSTableSizeWriter.getTotalWriteSize(nonExpiredSSTables, this.estimatedTotalKeys, cfs, txn.opType());
        this.estimatedSSTables = Math.max(1L, totalSize / maxSSTableSize);
    }

    private static long getTotalWriteSize(Iterable<SSTableReader> nonExpiredSSTables, long estimatedTotalKeys, ColumnFamilyStore cfs, OperationType compactionType) {
        long estimatedKeysBeforeCompaction = 0L;
        for (SSTableReader sstable : nonExpiredSSTables) {
            estimatedKeysBeforeCompaction += sstable.estimatedKeys();
        }
        estimatedKeysBeforeCompaction = Math.max(1L, estimatedKeysBeforeCompaction);
        double estimatedCompactionRatio = (double)estimatedTotalKeys / (double)estimatedKeysBeforeCompaction;
        return Math.round(estimatedCompactionRatio * (double)cfs.getExpectedCompactedFileSize(nonExpiredSSTables, compactionType));
    }

    @Override
    protected boolean shouldSwitchWriterInCurrentLocation(DecoratedKey key) {
        return this.sstableWriter.currentWriter().getEstimatedOnDiskBytesWritten() > this.maxSSTableSize;
    }

    @Override
    protected int sstableLevel() {
        return this.level;
    }

    @Override
    protected long sstableKeyCount() {
        return this.estimatedTotalKeys / this.estimatedSSTables;
    }

    @Override
    protected long getExpectedWriteSize() {
        return Math.min(this.maxSSTableSize, super.getExpectedWriteSize());
    }
}

