/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.postings;

import java.io.IOException;
import java.util.PrimitiveIterator;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.lucene.util.LongHeap;

public class VectorPostingList
implements PostingList {
    private final LongHeap segmentRowIds;
    private final int size;
    private final int visitedCount;

    public VectorPostingList(PrimitiveIterator.OfInt source, int limit, int visitedCount) {
        this.visitedCount = visitedCount;
        this.segmentRowIds = new LongHeap(Math.max(limit, 1));
        int n = 0;
        while (source.hasNext() && n++ < limit) {
            this.segmentRowIds.push((long)source.nextInt());
        }
        this.size = n;
    }

    @Override
    public long nextPosting() {
        if (this.segmentRowIds.size() == 0) {
            return Long.MAX_VALUE;
        }
        return this.segmentRowIds.pop();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long advance(long targetRowID) throws IOException {
        long rowId;
        while ((rowId = this.nextPosting()) < targetRowID) {
        }
        return rowId;
    }

    public int getVisitedCount() {
        return this.visitedCount;
    }
}

