/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.StartupChecksOptions;
import org.apache.cassandra.exceptions.StartupException;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.service.StartupCheck;
import org.apache.cassandra.service.StartupChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemOwnershipCheck
implements StartupCheck {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemOwnershipCheck.class);
    public static final String FILE_SYSTEM_CHECK_OWNERSHIP_TOKEN = "CassandraOwnershipToken";
    public static final String DEFAULT_FS_OWNERSHIP_FILENAME = ".cassandra_fs_ownership";
    static final String VERSION = "version";
    static final String VOLUME_COUNT = "volume_count";
    static final String TOKEN = "ownership_token";
    static final String ERROR_PREFIX = "FS ownership check failed; ";
    static final String MISSING_PROPERTY = "property '%s' required for fs ownership check not supplied";
    static final String NO_OWNERSHIP_FILE = "no file found in tree for %s";
    static final String MULTIPLE_OWNERSHIP_FILES = "multiple files found in tree for %s";
    static final String INCONSISTENT_FILES_FOUND = "inconsistent ownership files found on disk: %s";
    static final String INVALID_FILE_COUNT = "number of ownership files found doesn't match expected";
    static final String MISMATCHING_TOKEN = "token found on disk does not match supplied";
    static final String UNSUPPORTED_VERSION = "unsupported version '%s' in ownership file";
    static final String INVALID_PROPERTY_VALUE = "invalid or missing value for property '%s'";
    static final String READ_EXCEPTION = "error when checking for fs ownership file";
    private final Supplier<Iterable<String>> dirs;

    FileSystemOwnershipCheck() {
        this(() -> Iterables.concat(Arrays.asList(DatabaseDescriptor.getAllDataFileLocations()), Arrays.asList(DatabaseDescriptor.getCommitLogLocation(), DatabaseDescriptor.getSavedCachesLocation(), DatabaseDescriptor.getHintsDirectory().absolutePath())));
    }

    @VisibleForTesting
    FileSystemOwnershipCheck(Supplier<Iterable<String>> dirs) {
        this.dirs = dirs;
    }

    @Override
    public StartupChecks.StartupCheckType getStartupCheckType() {
        return StartupChecks.StartupCheckType.check_filesystem_ownership;
    }

    @Override
    public void execute(StartupChecksOptions options) throws StartupException {
        if (!this.isEnabled(options)) {
            logger.info("Filesystem ownership check is not enabled.");
            return;
        }
        Map<String, Object> config = options.getConfig(this.getStartupCheckType());
        String expectedToken = this.constructTokenFromProperties(config);
        String tokenFilename = this.getFsOwnershipFilename(config);
        HashMap<String, Integer> foundPerTargetDir = new HashMap<String, Integer>();
        HashMap<Path, Properties> foundProperties = new HashMap<Path, Properties>();
        for (String dataDir : this.dirs.get()) {
            logger.info("Checking for fs ownership details in file hierarchy for {}", (Object)dataDir);
            int foundFiles = 0;
            Path dir = File.getPath(dataDir, new String[0]).normalize();
            do {
                File tokenFile;
                if (!(tokenFile = this.resolve(dir, tokenFilename)).exists()) continue;
                ++foundFiles;
                if (foundProperties.containsKey(tokenFile.toPath().toAbsolutePath())) continue;
                try (BufferedReader reader = Files.newBufferedReader(tokenFile.toPath());){
                    Properties props = new Properties();
                    props.load(reader);
                    foundProperties.put(tokenFile.toPath().toAbsolutePath(), props);
                }
                catch (Exception e2) {
                    logger.error("Error reading fs ownership file from disk", (Throwable)e2);
                    throw this.exception(READ_EXCEPTION);
                }
            } while ((dir = dir.getParent()) != null);
            foundPerTargetDir.put(dataDir, foundFiles);
        }
        if (foundPerTargetDir.containsValue(0)) {
            throw this.exception(String.format(NO_OWNERSHIP_FILE, foundPerTargetDir.entrySet().stream().filter(e -> (Integer)e.getValue() == 0).map(Map.Entry::getKey).collect(Collectors.joining("', '", "'", "'"))));
        }
        Set multipleTokens = foundPerTargetDir.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!multipleTokens.isEmpty()) {
            throw this.exception(String.format(MULTIPLE_OWNERSHIP_FILES, String.join((CharSequence)",", multipleTokens)));
        }
        assert (!foundProperties.isEmpty());
        HashMultimap byHash = HashMultimap.create();
        foundProperties.forEach((arg_0, arg_1) -> FileSystemOwnershipCheck.lambda$execute$3((Multimap)byHash, arg_0, arg_1));
        if (byHash.keySet().size() > 1) {
            throw this.exception(String.format(INCONSISTENT_FILES_FOUND, byHash.keySet().stream().map(arg_0 -> FileSystemOwnershipCheck.lambda$execute$4((Multimap)byHash, arg_0)).sorted().collect(Collectors.joining(", "))));
        }
        Properties fromDisk = (Properties)foundProperties.entrySet().iterator().next().getValue();
        int version = this.getIntProperty(fromDisk, VERSION);
        if (version != 1) {
            throw this.exception(String.format(UNSUPPORTED_VERSION, version));
        }
        int volumeCount = this.getIntProperty(fromDisk, VOLUME_COUNT);
        if (volumeCount != foundProperties.size()) {
            throw this.exception(INVALID_FILE_COUNT);
        }
        String token = this.getRequiredProperty(fromDisk, TOKEN);
        if (!expectedToken.equals(token)) {
            throw this.exception(MISMATCHING_TOKEN);
        }
        logger.info("Successfully verified fs ownership");
    }

    protected String constructTokenFromProperties(Map<String, Object> config) throws StartupException {
        String cluster = this.getOwnershipToken(config);
        if (null == cluster || cluster.isEmpty()) {
            throw this.exception(String.format(MISSING_PROPERTY, FILE_SYSTEM_CHECK_OWNERSHIP_TOKEN));
        }
        return cluster;
    }

    private int getIntProperty(Properties props, String key) throws StartupException {
        String val = this.getRequiredProperty(props, key);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw this.exception(String.format(INVALID_PROPERTY_VALUE, key));
        }
    }

    private String getRequiredProperty(Properties props, String key) throws StartupException {
        String s = props.getProperty(key);
        if (null == s || s.isEmpty()) {
            throw this.exception(String.format(INVALID_PROPERTY_VALUE, key));
        }
        return s;
    }

    private File resolve(Path dir, String filename) throws StartupException {
        try {
            return new File(dir.resolve(filename));
        }
        catch (Exception e) {
            logger.error("Encountered error resolving path ownership file {} relative to dir {}", (Object)filename, (Object)dir);
            throw this.exception(READ_EXCEPTION);
        }
    }

    private StartupException exception(String message) {
        return new StartupException(3, ERROR_PREFIX + message);
    }

    public boolean isEnabled(StartupChecksOptions options) {
        boolean enabledFromYaml = options.isEnabled(this.getStartupCheckType());
        return CassandraRelevantProperties.FILE_SYSTEM_CHECK_ENABLE.getBoolean(enabledFromYaml);
    }

    public String getFsOwnershipFilename(Map<String, Object> config) {
        if (CassandraRelevantProperties.FILE_SYSTEM_CHECK_OWNERSHIP_FILENAME.isPresent()) {
            logger.warn(String.format("Cassandra system property flag %s is deprecated and you should use startup check configuration in cassandra.yaml", CassandraRelevantProperties.FILE_SYSTEM_CHECK_OWNERSHIP_FILENAME.getKey()));
            return CassandraRelevantProperties.FILE_SYSTEM_CHECK_OWNERSHIP_FILENAME.getString();
        }
        Object fsOwnershipFilename = config.get("ownership_filename");
        return fsOwnershipFilename == null ? CassandraRelevantProperties.FILE_SYSTEM_CHECK_OWNERSHIP_FILENAME.getDefaultValue() : (String)fsOwnershipFilename;
    }

    public String getOwnershipToken(Map<String, Object> config) {
        if (CassandraRelevantProperties.FILE_SYSTEM_CHECK_OWNERSHIP_TOKEN.isPresent()) {
            logger.warn(String.format("Cassandra system property flag %s is deprecated and you should use startup check configuration in cassandra.yaml", CassandraRelevantProperties.FILE_SYSTEM_CHECK_OWNERSHIP_TOKEN.getKey()));
            return CassandraRelevantProperties.FILE_SYSTEM_CHECK_OWNERSHIP_TOKEN.getString();
        }
        Object ownershipToken = config.get(TOKEN);
        return ownershipToken == null ? CassandraRelevantProperties.FILE_SYSTEM_CHECK_OWNERSHIP_TOKEN.getDefaultValue() : (String)ownershipToken;
    }

    private static /* synthetic */ String lambda$execute$4(Multimap byHash, Integer hash) {
        return byHash.get((Object)hash).stream().map(Path::toString).sorted().collect(Collectors.joining("', '", "['", "']"));
    }

    private static /* synthetic */ void lambda$execute$3(Multimap byHash, Path key, Properties value) {
        byHash.put((Object)value.hashCode(), (Object)key);
    }
}

