/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import o.a.c.sidecar.client.shaded.client.exception.RetriesExhaustedException;
import o.a.c.sidecar.client.shaded.common.request.Request;
import o.a.c.sidecar.client.shaded.common.request.data.CreateSliceRequestPayload;
import o.a.c.sidecar.client.shaded.common.response.data.RingEntry;
import org.apache.cassandra.spark.bulkwriter.BulkWriteValidator;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.CancelJobEvent;
import org.apache.cassandra.spark.bulkwriter.CassandraContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CassandraTopologyMonitor;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApiImpl;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageStreamResult;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CreatedRestoreSlice;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.ImportCompletionCoordinator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.StorageClient;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.MultiClusterReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.exception.ImportFailedException;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ImportCompletionCoordinatorTest {
    private static final int TOTAL_INSTANCES = 10;
    BulkWriterContext mockWriterContext;
    BulkWriteValidator writerValidator;
    TokenRangeMapping<RingInstance> topology;
    JobInfo mockJobInfo;
    CloudStorageDataTransferApiImpl dataTransferApi;
    UUID jobId;
    StorageTransportExtension mockExtension;
    ArgumentCaptor<String> appliedObjectKeys;
    Consumer<CancelJobEvent> onCancelJob;

    ImportCompletionCoordinatorTest() {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.mockJobInfo = (JobInfo)Mockito.mock(JobInfo.class);
        this.jobId = UUID.randomUUID();
        Mockito.when((Object)this.mockJobInfo.getId()).thenReturn((Object)this.jobId.toString());
        Mockito.when((Object)this.mockJobInfo.getRestoreJobId()).thenReturn((Object)this.jobId);
        Mockito.when((Object)this.mockJobInfo.qualifiedTableName()).thenReturn((Object)new QualifiedTableName("testkeyspace", "testtable"));
        Mockito.when((Object)this.mockJobInfo.getConsistencyLevel()).thenReturn((Object)ConsistencyLevel.CL.QUORUM);
        Mockito.when((Object)this.mockJobInfo.effectiveSidecarPort()).thenReturn((Object)9043);
        Mockito.when((Object)this.mockJobInfo.jobKeepAliveMinutes()).thenReturn((Object)-1);
        this.mockWriterContext = (BulkWriterContext)Mockito.mock(BulkWriterContext.class);
        ClusterInfo mockClusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)this.mockWriterContext.cluster()).thenReturn((Object)mockClusterInfo);
        CassandraContext mockCassandraContext = (CassandraContext)Mockito.mock(CassandraContext.class);
        Mockito.when((Object)mockClusterInfo.getCassandraContext()).thenReturn((Object)mockCassandraContext);
        ImmutableMap rfOptions = ImmutableMap.of((Object)"DC1", (Object)3);
        ReplicationFactor rf = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)rfOptions);
        Mockito.when((Object)mockClusterInfo.replicationFactor()).thenReturn((Object)rf);
        this.topology = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)rfOptions, 10);
        Mockito.when((Object)mockClusterInfo.getTokenRangeMapping(ArgumentMatchers.anyBoolean())).thenReturn(this.topology);
        Mockito.when((Object)this.mockWriterContext.job()).thenReturn((Object)this.mockJobInfo);
        this.writerValidator = new BulkWriteValidator(this.mockWriterContext, (ReplicaAwareFailureHandler)new MultiClusterReplicaAwareFailureHandler(Partitioner.Murmur3Partitioner));
        CloudStorageDataTransferApiImpl api = new CloudStorageDataTransferApiImpl(this.mockJobInfo, (SidecarClient)Mockito.mock(SidecarClient.class), (StorageClient)Mockito.mock(StorageClient.class), null);
        this.dataTransferApi = (CloudStorageDataTransferApiImpl)Mockito.spy((Object)api);
        this.mockExtension = (StorageTransportExtension)Mockito.mock(StorageTransportExtension.class);
        this.appliedObjectKeys = ArgumentCaptor.forClass(String.class);
        ((StorageTransportExtension)Mockito.doNothing().when((Object)this.mockExtension)).onObjectApplied((String)ArgumentMatchers.any(), (String)this.appliedObjectKeys.capture(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        this.onCancelJob = event -> {
            throw new RuntimeException("It should not be called");
        };
    }

    @Test
    void testAwaitForCompletionWithNoErrors() {
        List<CloudStorageStreamResult> resultList = this.buildBlobStreamResult(0, false, 0);
        ImportCompletionCoordinator.of((long)0L, (BulkWriterContext)this.mockWriterContext, (CloudStorageDataTransferApi)this.dataTransferApi, (BulkWriteValidator)this.writerValidator, resultList, (StorageTransportExtension)this.mockExtension, this.onCancelJob).await();
        this.validateAllSlicesWereCalledAtMostOnce(resultList);
        ((ListAssert)Assertions.assertThat((List)this.appliedObjectKeys.getAllValues()).as("All objects should be applied and reported for exactly once", new Object[0])).hasSize(resultList.size());
        Assertions.assertThat(new HashSet(this.appliedObjectKeys.getAllValues())).isEqualTo(this.allTestObjectKeys());
    }

    @Test
    void testAwaitForCompletionWithNoErrorsAndSlowImport() {
        List<CloudStorageStreamResult> resultList = this.buildBlobStreamResult(0, true, 0);
        ImportCompletionCoordinator.of((long)0L, (BulkWriterContext)this.mockWriterContext, (CloudStorageDataTransferApi)this.dataTransferApi, (BulkWriteValidator)this.writerValidator, resultList, (StorageTransportExtension)this.mockExtension, this.onCancelJob).await();
        this.validateAllSlicesWereCalledAtMostOnce(resultList);
        ((ListAssert)Assertions.assertThat((List)this.appliedObjectKeys.getAllValues()).as("All objects should be applied and reported for exactly once", new Object[0])).hasSize(resultList.size());
        Assertions.assertThat(new HashSet(this.appliedObjectKeys.getAllValues())).isEqualTo(this.allTestObjectKeys());
    }

    @Test
    void testAwaitForCompletionWithErrorsAndCLPasses() {
        List<CloudStorageStreamResult> resultList = this.buildBlobStreamResult(1, false, 0);
        ImportCompletionCoordinator.of((long)0L, (BulkWriterContext)this.mockWriterContext, (CloudStorageDataTransferApi)this.dataTransferApi, (BulkWriteValidator)this.writerValidator, resultList, (StorageTransportExtension)this.mockExtension, this.onCancelJob).await();
        this.validateAllSlicesWereCalledAtMostOnce(resultList);
        ((ListAssert)Assertions.assertThat((List)this.appliedObjectKeys.getAllValues()).as("All objects should be applied and reported for exactly once", new Object[0])).hasSize(resultList.size());
        Assertions.assertThat(new HashSet(this.appliedObjectKeys.getAllValues())).isEqualTo(this.allTestObjectKeys());
    }

    @Test
    void testAwaitForCompletionWithErrorsAndCLFails() {
        String errorMessage = "ranges with QUORUM for job " + String.valueOf(this.jobId) + " in phase WaitForImportCompletion";
        List<CloudStorageStreamResult> resultList = this.buildBlobStreamResult(2, false, 0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ImportCompletionCoordinator.of((long)0L, (BulkWriterContext)this.mockWriterContext, (CloudStorageDataTransferApi)this.dataTransferApi, (BulkWriteValidator)this.writerValidator, (List)resultList, (StorageTransportExtension)this.mockExtension, this.onCancelJob).await()).isInstanceOf(RuntimeException.class)).hasMessageContaining("Failed to write").hasMessageContaining(errorMessage).cause().isNotNull();
        this.validateAllSlicesWereCalledAtMostOnce(resultList);
        ((ListAssert)Assertions.assertThat((List)this.appliedObjectKeys.getAllValues()).as("No object should be applied and reported", new Object[0])).hasSize(0);
    }

    @Test
    void testCLUnsatisfiedRanges() {
        String errorMessage = "Some of the token ranges cannot satisfy with consistency level. job=" + String.valueOf(this.jobId) + " phase=WaitForImportCompletion";
        List<CloudStorageStreamResult> resultList = this.buildBlobStreamResult(0, false, 2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ImportCompletionCoordinator.of((long)0L, (BulkWriterContext)this.mockWriterContext, (CloudStorageDataTransferApi)this.dataTransferApi, (BulkWriteValidator)this.writerValidator, (List)resultList, (StorageTransportExtension)this.mockExtension, this.onCancelJob).await()).isInstanceOf(RuntimeException.class)).hasMessageContaining(errorMessage).hasNoCause();
        this.validateAllSlicesWereCalledAtMostOnce(resultList);
        ((ListAssert)Assertions.assertThat((List)this.appliedObjectKeys.getAllValues()).as("No object should be applied and reported", new Object[0])).hasSize(0);
    }

    @Test
    void testAwaitShouldPassWithStuckSliceWhenClSatisfied() {
        Mockito.when((Object)this.mockJobInfo.importCoordinatorTimeoutMultiplier()).thenReturn((Object)0.0);
        List<CloudStorageStreamResult> resultList = this.buildBlobStreamResultWithNoProgressImports(1, 0L);
        ImportCompletionCoordinator coordinator = ImportCompletionCoordinator.of((long)0L, (BulkWriterContext)this.mockWriterContext, (CloudStorageDataTransferApi)this.dataTransferApi, (BulkWriteValidator)this.writerValidator, resultList, (StorageTransportExtension)this.mockExtension, this.onCancelJob);
        coordinator.await();
        ((ListAssert)Assertions.assertThat((List)this.appliedObjectKeys.getAllValues()).as("All objects should be applied and reported for exactly once", new Object[0])).hasSize(resultList.size());
        Assertions.assertThat(new HashSet(this.appliedObjectKeys.getAllValues())).isEqualTo(this.allTestObjectKeys());
        Map importFutures = coordinator.importFutures();
        int cancelledImports = importFutures.keySet().stream().mapToInt(f -> f.isCancelled() ? 1 : 0).sum();
        ((AbstractIntegerAssert)Assertions.assertThat((int)cancelledImports).as("Each replica set should have a slice gets cancelled due to making no progress", new Object[0])).isEqualTo(10);
    }

    @Test
    void testAwaitShouldBlockUntilClSatisfiedWhenTimeoutIsLow() {
        Mockito.when((Object)this.mockJobInfo.importCoordinatorTimeoutMultiplier()).thenReturn((Object)1000.0);
        Mockito.when((Object)this.mockJobInfo.jobTimeoutSeconds()).thenReturn((Object)1L);
        List<CloudStorageStreamResult> resultList = this.buildBlobStreamResultWithNoProgressImports(1, 100L);
        ImportCompletionCoordinator coordinator = ImportCompletionCoordinator.of((long)System.nanoTime(), (BulkWriterContext)this.mockWriterContext, (CloudStorageDataTransferApi)this.dataTransferApi, (BulkWriteValidator)this.writerValidator, resultList, (StorageTransportExtension)this.mockExtension, this.onCancelJob);
        coordinator.await();
        ((ListAssert)Assertions.assertThat((List)this.appliedObjectKeys.getAllValues()).as("All objects should be applied and reported for exactly once", new Object[0])).hasSize(resultList.size());
        Assertions.assertThat(new HashSet(this.appliedObjectKeys.getAllValues())).isEqualTo(this.allTestObjectKeys());
        Map importFutures = coordinator.importFutures();
        int cancelledImports = importFutures.keySet().stream().mapToInt(f -> f.isCancelled() ? 1 : 0).sum();
        ((AbstractIntegerAssert)Assertions.assertThat((int)cancelledImports).as("Each replica set should have a slice gets cancelled due to making no progress", new Object[0])).isEqualTo(10);
    }

    @Test
    void testAwaitShouldBlockUntilTimeoutExceeds() {
        Mockito.when((Object)this.mockJobInfo.importCoordinatorTimeoutMultiplier()).thenReturn((Object)1000.0);
        long timeout = 5L;
        Mockito.when((Object)this.mockJobInfo.jobTimeoutSeconds()).thenReturn((Object)timeout);
        List<CloudStorageStreamResult> resultList = this.buildBlobStreamResultWithNoProgressImports(1, 100L);
        long startNanos = System.nanoTime();
        ImportCompletionCoordinator coordinator = ImportCompletionCoordinator.of((long)startNanos, (BulkWriterContext)this.mockWriterContext, (CloudStorageDataTransferApi)this.dataTransferApi, (BulkWriteValidator)this.writerValidator, resultList, (StorageTransportExtension)this.mockExtension, this.onCancelJob);
        coordinator.await();
        ((ListAssert)Assertions.assertThat((List)this.appliedObjectKeys.getAllValues()).as("All objects should be applied and reported for exactly once", new Object[0])).hasSize(resultList.size());
        Assertions.assertThat(new HashSet(this.appliedObjectKeys.getAllValues())).isEqualTo(this.allTestObjectKeys());
        Map importFutures = coordinator.importFutures();
        int cancelledImports = importFutures.keySet().stream().mapToInt(f -> f.isCancelled() ? 1 : 0).sum();
        ((AbstractIntegerAssert)Assertions.assertThat((int)cancelledImports).as("Each replica set should have a slice gets cancelled due to making no progress", new Object[0])).isEqualTo(10);
        ((AbstractLongAssert)Assertions.assertThat((long)(System.nanoTime() - startNanos)).as("ImportCompletionCoordinator should wait for at least " + timeout + " seconds", new Object[0])).isGreaterThan(TimeUnit.SECONDS.toNanos(timeout));
    }

    @Test
    void testJobCancelOnTopologyChanged() {
        AtomicBoolean isCancelled = new AtomicBoolean(false);
        Consumer<CancelJobEvent> onCancel = event -> isCancelled.set(true);
        BulkWriterContext mockWriterContext = (BulkWriterContext)Mockito.mock(BulkWriterContext.class);
        ClusterInfo mockClusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)mockWriterContext.cluster()).thenReturn((Object)mockClusterInfo);
        Mockito.when((Object)mockClusterInfo.getTokenRangeMapping(false)).thenReturn(TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 10)).thenReturn(TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 11));
        List<CloudStorageStreamResult> resultList = this.buildBlobStreamResult(0, false, 0);
        AtomicReference<Object> monitorRef = new AtomicReference<Object>(null);
        ImportCompletionCoordinator coordinator = new ImportCompletionCoordinator(0L, mockWriterContext, (CloudStorageDataTransferApi)this.dataTransferApi, this.writerValidator, resultList, this.mockExtension, onCancel, (clusterInfo, onCancelJob) -> {
            monitorRef.set(new CassandraTopologyMonitor(clusterInfo, onCancelJob));
            return (CassandraTopologyMonitor)monitorRef.get();
        });
        ((CassandraTopologyMonitor)monitorRef.get()).checkTopologyOnDemand();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ImportCompletionCoordinator)coordinator).await()).isInstanceOf(ImportFailedException.class)).hasMessage("Topology changed during bulk write").isEqualTo((Object)coordinator.failure());
        Assertions.assertThat((boolean)isCancelled.get()).isTrue();
    }

    @Test
    void testEstimateTimeout() {
        long timeToAllSatisfiedNanos = TimeUnit.SECONDS.toNanos(3L);
        long elapsedNanos = TimeUnit.SECONDS.toNanos(10L);
        double importCoordinatorTimeoutMultiplier = 1.0;
        double minSliceSize = 100.0;
        double maxSliceSize = 200.0;
        long jobTimeoutSeconds = 0L;
        long estimatedTimeout = ImportCompletionCoordinator.estimateTimeoutNanos((long)timeToAllSatisfiedNanos, (long)elapsedNanos, (double)importCoordinatorTimeoutMultiplier, (double)minSliceSize, (double)maxSliceSize, (long)jobTimeoutSeconds);
        ((AbstractLongAssert)Assertions.assertThat((long)estimatedTimeout).as("jobTimeoutSeconds is 0. It should not wait for any additional time", new Object[0])).isEqualTo(0L);
        jobTimeoutSeconds = Integer.MAX_VALUE;
        estimatedTimeout = ImportCompletionCoordinator.estimateTimeoutNanos((long)timeToAllSatisfiedNanos, (long)elapsedNanos, (double)importCoordinatorTimeoutMultiplier, (double)minSliceSize, (double)maxSliceSize, (long)jobTimeoutSeconds);
        ((AbstractLongAssert)Assertions.assertThat((long)estimatedTimeout).as("It takes 3 seconds to achieve CL; Based on the size estimate, it should take 200 / 100 * 3 seconds in addition", new Object[0])).isEqualTo(TimeUnit.SECONDS.toNanos(6L));
        importCoordinatorTimeoutMultiplier = 0.0;
        estimatedTimeout = ImportCompletionCoordinator.estimateTimeoutNanos((long)timeToAllSatisfiedNanos, (long)elapsedNanos, (double)importCoordinatorTimeoutMultiplier, (double)minSliceSize, (double)maxSliceSize, (long)jobTimeoutSeconds);
        ((AbstractLongAssert)Assertions.assertThat((long)estimatedTimeout).as("When timeout multiplier is 0, there is no additional wait time", new Object[0])).isEqualTo(0L);
        importCoordinatorTimeoutMultiplier = 0.5;
        estimatedTimeout = ImportCompletionCoordinator.estimateTimeoutNanos((long)timeToAllSatisfiedNanos, (long)elapsedNanos, (double)importCoordinatorTimeoutMultiplier, (double)minSliceSize, (double)maxSliceSize, (long)jobTimeoutSeconds);
        ((AbstractLongAssert)Assertions.assertThat((long)estimatedTimeout).as("The estimate is 200 / 100 * 3 * 0.5 == 3", new Object[0])).isEqualTo(TimeUnit.SECONDS.toNanos(3L));
    }

    private Set<String> allTestObjectKeys() {
        return IntStream.range(0, 10).boxed().map(i -> "key_for_instance_" + i).collect(Collectors.toSet());
    }

    private List<CloudStorageStreamResult> buildBlobStreamResultWithNoProgressImports(int noProgressInstanceCount, long importTimeMillis) {
        return this.buildBlobStreamResult(0, false, 0, noProgressInstanceCount, importTimeMillis);
    }

    private List<CloudStorageStreamResult> buildBlobStreamResult(int failedInstanceCount, boolean simulateSlowImport, int unavailableInstanceCount) {
        return this.buildBlobStreamResult(failedInstanceCount, simulateSlowImport, unavailableInstanceCount, 0, 0L);
    }

    private List<CloudStorageStreamResult> buildBlobStreamResult(int failedInstanceCount, boolean simulateSlowImport, int unavailableInstanceCount, int noProgressInstanceCount, long minimumImportTimeMills) {
        ArrayList<CloudStorageStreamResult> resultList = new ArrayList<CloudStorageStreamResult>();
        int totalInstances = 10;
        long importTime = Math.max(0L, minimumImportTimeMills);
        for (int i = 0; i < totalInstances; ++i) {
            List<RingInstance> replicaSet = Arrays.asList(this.ringInstance(i, totalInstances), this.ringInstance(i + 1, totalInstances), this.ringInstance(i + 2, totalInstances));
            HashSet<CreatedRestoreSlice> createdRestoreSlices = new HashSet<CreatedRestoreSlice>();
            int failedPerReplica = failedInstanceCount;
            int unavailablePerReplica = unavailableInstanceCount;
            int noProgressPerReplicaSet = noProgressInstanceCount;
            CreateSliceRequestPayload mockCreateSliceRequestPayload = (CreateSliceRequestPayload)Mockito.mock(CreateSliceRequestPayload.class);
            Mockito.when((Object)mockCreateSliceRequestPayload.firstToken()).thenReturn((Object)BigInteger.valueOf(100 * (i - 1) + 1));
            Mockito.when((Object)mockCreateSliceRequestPayload.endToken()).thenReturn((Object)BigInteger.valueOf(100 * i));
            Mockito.when((Object)mockCreateSliceRequestPayload.sliceId()).thenReturn((Object)UUID.randomUUID().toString());
            Mockito.when((Object)mockCreateSliceRequestPayload.key()).thenReturn((Object)("key_for_instance_" + i));
            Mockito.when((Object)mockCreateSliceRequestPayload.bucket()).thenReturn((Object)"bucket");
            Mockito.when((Object)mockCreateSliceRequestPayload.compressedSize()).thenReturn((Object)1L);
            Mockito.when((Object)mockCreateSliceRequestPayload.compressedSizeOrZero()).thenReturn((Object)1L);
            ArrayList<RingInstance> passedReplicaSet = new ArrayList<RingInstance>();
            for (RingInstance instance : replicaSet) {
                if (unavailablePerReplica-- > 0) continue;
                passedReplicaSet.add(instance);
                createdRestoreSlices.add(new CreatedRestoreSlice(mockCreateSliceRequestPayload));
                if (simulateSlowImport && i == totalInstances - 1) {
                    ((CloudStorageDataTransferApiImpl)Mockito.doAnswer(invocation -> {
                        Thread.sleep(importTime + (long)ThreadLocalRandom.current().nextInt(2000));
                        return CompletableFuture.completedFuture(null);
                    }).when((Object)this.dataTransferApi)).createRestoreSliceFromDriver((SidecarInstance)ArgumentMatchers.eq((Object)new SidecarInstanceImpl(instance.nodeName(), 9043)), (CreateSliceRequestPayload)ArgumentMatchers.eq((Object)mockCreateSliceRequestPayload));
                    continue;
                }
                if (noProgressPerReplicaSet-- > 0) {
                    ((CloudStorageDataTransferApiImpl)Mockito.doReturn(new CompletableFuture()).when((Object)this.dataTransferApi)).createRestoreSliceFromDriver((SidecarInstance)ArgumentMatchers.eq((Object)new SidecarInstanceImpl(instance.nodeName(), 9043)), (CreateSliceRequestPayload)ArgumentMatchers.eq((Object)mockCreateSliceRequestPayload));
                    continue;
                }
                if (failedPerReplica-- > 0) {
                    CompletableFuture failure = new CompletableFuture();
                    failure.completeExceptionally((Throwable)RetriesExhaustedException.of((int)10, (Request)((Request)Mockito.mock(Request.class)), null));
                    ((CloudStorageDataTransferApiImpl)Mockito.doAnswer(invocation -> {
                        Thread.sleep(importTime);
                        return failure;
                    }).when((Object)this.dataTransferApi)).createRestoreSliceFromDriver((SidecarInstance)ArgumentMatchers.eq((Object)new SidecarInstanceImpl(instance.nodeName(), 9043)), (CreateSliceRequestPayload)ArgumentMatchers.eq((Object)mockCreateSliceRequestPayload));
                    continue;
                }
                ((CloudStorageDataTransferApiImpl)Mockito.doAnswer(invocation -> {
                    Thread.sleep(importTime);
                    return CompletableFuture.completedFuture(null);
                }).when((Object)this.dataTransferApi)).createRestoreSliceFromDriver((SidecarInstance)ArgumentMatchers.eq((Object)new SidecarInstanceImpl(instance.nodeName(), 9043)), (CreateSliceRequestPayload)ArgumentMatchers.eq((Object)mockCreateSliceRequestPayload));
            }
            CloudStorageStreamResult result = new CloudStorageStreamResult("", (Range)Mockito.mock(Range.class), Collections.emptyList(), passedReplicaSet, createdRestoreSlices, createdRestoreSlices.size(), 0L, 0L);
            resultList.add(result);
        }
        return resultList;
    }

    private void validateAllSlicesWereCalledAtMostOnce(List<CloudStorageStreamResult> resultList) {
        for (CloudStorageStreamResult cloudStorageStreamResult : resultList) {
            for (RingInstance instance : cloudStorageStreamResult.passed) {
                for (CreatedRestoreSlice createdRestoreSlice : cloudStorageStreamResult.createdRestoreSlices) {
                    ((CloudStorageDataTransferApiImpl)Mockito.verify((Object)this.dataTransferApi, (VerificationMode)Mockito.atMostOnce())).createRestoreSliceFromDriver((SidecarInstance)ArgumentMatchers.eq((Object)new SidecarInstanceImpl(instance.nodeName(), 9043)), (CreateSliceRequestPayload)ArgumentMatchers.eq((Object)createdRestoreSlice.sliceRequestPayload()));
                }
            }
        }
    }

    private RingInstance ringInstance(int i, int totalInstances) {
        int instanceInRing = i % totalInstances + 1;
        return new RingInstance(new RingEntry.Builder().datacenter("DC1").rack("Rack").address("127.0.0." + instanceInRing).token(String.valueOf(i * 100000)).fqdn("DC1-i" + instanceInRing).build());
    }
}

