/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.spark.utils.FilterUtils;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilterUtilsTests {
    @Test
    public void testPartialPartitionKeyFilter() {
        Filter[] filters = new Filter[]{new EqualTo("a", (Object)"1")};
        Assertions.assertThatThrownBy(() -> FilterUtils.extractPartitionKeyValues((Filter[])filters, new HashSet<String>(Arrays.asList("a", "b")))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testValidPartitionKeyValuesExtracted() {
        Filter[] filters = new Filter[]{new EqualTo("a", (Object)"1"), new In("b", (Object[])new String[]{"2", "3"}), new EqualTo("c", (Object)"2")};
        Map partitionKeyValues = FilterUtils.extractPartitionKeyValues((Filter[])filters, new HashSet<String>(Arrays.asList("a", "b")));
        Assertions.assertThat((Map)partitionKeyValues).doesNotContainKey((Object)"c");
        Assertions.assertThat((Map)partitionKeyValues).containsKey((Object)"a");
        Assertions.assertThat((Map)partitionKeyValues).containsKey((Object)"b");
    }

    @Test
    public void testCartesianProductOfInValidValues() {
        List<List> orderedValues = Arrays.asList(Arrays.asList("1", "2"), Arrays.asList("a", "b", "c"), Collections.emptyList());
        Assertions.assertThatThrownBy(() -> FilterUtils.cartesianProduct((List)orderedValues)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testCartesianProductOfEmptyList() {
        List orderedValues = Collections.emptyList();
        List product = FilterUtils.cartesianProduct(orderedValues);
        Assertions.assertThat((List)product).isNotEmpty();
        Assertions.assertThat((List)product).hasSize(1);
        Assertions.assertThat((List)((List)product.get(0))).isEmpty();
    }

    @Test
    public void testCartesianProductOfSingleton() {
        List<List<String>> orderedValues = Collections.singletonList(Arrays.asList("a", "b", "c"));
        Assertions.assertThat((List)FilterUtils.cartesianProduct(orderedValues)).hasSize(3);
    }
}

