/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.base.Preconditions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum FileType {
    DATA("Data.db"),
    INDEX("Index.db"),
    FILTER("Filter.db"),
    STATISTICS("Statistics.db"),
    SUMMARY("Summary.db"),
    COMPRESSION_INFO("CompressionInfo.db"),
    TOC("TOC.txt"),
    DIGEST("Digest.sha1"),
    CRC("CRC.db"),
    CRC32("Digest.crc32"),
    COMMITLOG(".log"),
    PARTITIONS_INDEX("Partitions.db"),
    ROWS_INDEX("Rows.db");

    private final String fileSuffix;
    private static final Map<String, FileType> FILE_TYPE_HASH_MAP;

    private FileType(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public static FileType fromExtension(String extension) {
        Preconditions.checkArgument((boolean)FILE_TYPE_HASH_MAP.containsKey(extension), (Object)("Unknown sstable file type: " + extension));
        return FILE_TYPE_HASH_MAP.get(extension);
    }

    @Nullable
    public static Path resolveComponentFile(FileType fileType, Path dataFilePath) {
        Path filePath = fileType == DATA ? dataFilePath : dataFilePath.resolveSibling(dataFilePath.getFileName().toString().replace(DATA.getFileSuffix(), fileType.getFileSuffix()));
        return Files.exists(filePath, new LinkOption[0]) ? filePath : null;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    static {
        FILE_TYPE_HASH_MAP = new HashMap<String, FileType>();
        for (FileType fileType : FileType.values()) {
            FILE_TYPE_HASH_MAP.put(fileType.getFileSuffix(), fileType);
        }
    }
}

