/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static void closeQuietly(@Nullable AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                LOGGER.warn("Exception closing {}", (Object)closeable.getClass().getName(), (Object)throwable);
            }
        }
    }

    public static boolean isNotEmpty(Path path) {
        return IOUtils.size(path) > 0L;
    }

    public static long size(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void clearDirectory(Path path) {
        IOUtils.clearDirectory(path, log -> {});
    }

    public static void clearDirectory(Path path, Consumer<Path> logger) {
        try (Stream<Path> walker = Files.walk(path, new FileVisitOption[0]);){
            walker.sorted(Comparator.reverseOrder()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    logger.accept((Path)file);
                    Files.delete(file);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

