/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.Range;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.spark.bulkwriter.TokenPartitioner;
import org.jetbrains.annotations.NotNull;

public final class BroadcastableTokenPartitioner
implements Serializable {
    private static final long serialVersionUID = -8787074052066841748L;
    private final Map<Range<BigInteger>, Integer> partitionEntries;
    private final Integer numberSplits;

    public static BroadcastableTokenPartitioner from(@NotNull TokenPartitioner source) {
        HashMap<Range<BigInteger>, Integer> partitionEntries = new HashMap<Range<BigInteger>, Integer>();
        for (int i = 0; i < source.numPartitions(); ++i) {
            Range<BigInteger> range = source.getTokenRange(i);
            if (range == null) continue;
            partitionEntries.put(range, i);
        }
        return new BroadcastableTokenPartitioner(partitionEntries, source.numSplits());
    }

    private BroadcastableTokenPartitioner(Map<Range<BigInteger>, Integer> partitionEntries, Integer numberSplits) {
        this.partitionEntries = partitionEntries;
        this.numberSplits = numberSplits;
    }

    public Map<Range<BigInteger>, Integer> getPartitionEntries() {
        return this.partitionEntries;
    }

    public Integer numSplits() {
        return this.numberSplits;
    }
}

