/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import o.a.c.sidecar.client.shaded.common.request.data.CreateSliceRequestPayload;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatedRestoreSlice
implements Serializable {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(CreatedRestoreSlice.class);
    private static final long serialVersionUID = 1738928448022537598L;
    private transient CreateSliceRequestPayload sliceRequestPayload;
    private transient Set<CassandraInstance> succeededInstances;
    private transient boolean isSatisfied = false;
    public final String sliceRequestPayloadJson;

    public CreatedRestoreSlice(@NotNull CreateSliceRequestPayload sliceRequestPayload) {
        this.sliceRequestPayload = sliceRequestPayload;
        this.sliceRequestPayloadJson = CreatedRestoreSlice.toJson(sliceRequestPayload);
    }

    public CreateSliceRequestPayload sliceRequestPayload() {
        if (this.sliceRequestPayloadJson == null) {
            throw new IllegalStateException("sliceRequestPayloadJson cannot be null");
        }
        if (this.sliceRequestPayload != null) {
            return this.sliceRequestPayload;
        }
        try {
            this.sliceRequestPayload = (CreateSliceRequestPayload)MAPPER.readValue(this.sliceRequestPayloadJson, CreateSliceRequestPayload.class);
            return this.sliceRequestPayload;
        }
        catch (Exception exception) {
            LOGGER.error("Unable to deserialize CreateSliceRequestPayload from JSON. requestPayloadJson={}", (Object)this.sliceRequestPayloadJson, (Object)exception);
            throw new RuntimeException("Unable to deserialize CreateSliceRequestPayload from JSON", exception);
        }
    }

    public void addSucceededInstance(CassandraInstance instance) {
        this.succeededInstances().add(instance);
    }

    public synchronized ConsistencyLevelCheckResult checkForConsistencyLevel(ConsistencyLevel consistencyLevel, ReplicationFactor replicationFactor, String localDC) {
        if (this.isSatisfied) {
            return ConsistencyLevelCheckResult.ALREADY_SATISFIED;
        }
        if (!this.succeededInstances().isEmpty() && consistencyLevel.canBeSatisfied(this.succeededInstances(), Collections.emptyList(), replicationFactor, localDC)) {
            this.isSatisfied = true;
            return ConsistencyLevelCheckResult.SATISFIED;
        }
        return ConsistencyLevelCheckResult.NOT_SATISFIED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatedRestoreSlice that = (CreatedRestoreSlice)o;
        return Objects.equals(this.sliceRequestPayloadJson, that.sliceRequestPayloadJson);
    }

    public int hashCode() {
        return Objects.hash(this.sliceRequestPayloadJson);
    }

    public String toString() {
        return this.sliceRequestPayload.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<CassandraInstance> succeededInstances() {
        Set<CassandraInstance> currentInstances = this.succeededInstances;
        if (currentInstances != null) {
            return currentInstances;
        }
        CreatedRestoreSlice createdRestoreSlice = this;
        synchronized (createdRestoreSlice) {
            if (this.succeededInstances == null) {
                this.succeededInstances = ConcurrentHashMap.newKeySet();
            }
        }
        return this.succeededInstances;
    }

    private static String toJson(@NotNull CreateSliceRequestPayload sliceRequestPayload) {
        try {
            return MAPPER.writeValueAsString((Object)sliceRequestPayload);
        }
        catch (JsonProcessingException jsonProcessingException) {
            LOGGER.error("Unable to serialize CreateSliceRequestPayload to JSON. requestPayload={}", (Object)sliceRequestPayload, (Object)jsonProcessingException);
            throw new RuntimeException("Unable to serialize CreateSliceRequestPayload to JSON", jsonProcessingException);
        }
    }

    public static enum ConsistencyLevelCheckResult {
        NOT_SATISFIED,
        SATISFIED,
        ALREADY_SATISFIED;

    }
}

