/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.util;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.spark.TaskContext;

public final class TaskContextUtils {
    private TaskContextUtils() {
    }

    public static Range<BigInteger> getTokenRange(TaskContext taskContext, JobInfo job) {
        return job.getTokenPartitioner().getTokenRange(taskContext.partitionId());
    }

    public static String createStreamSessionId(TaskContext taskContext) {
        return String.format("%d-%d-%s", taskContext.partitionId(), taskContext.attemptNumber(), UUID.randomUUID());
    }

    public static Path getPartitionUniquePath(String basePath, String jobId, TaskContext taskContext) {
        return Paths.get(basePath, jobId, Integer.toString(taskContext.stageAttemptNumber()), Integer.toString(taskContext.attemptNumber()), Integer.toString(taskContext.partitionId()));
    }
}

