/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Set;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.reader.AbstractComplexTypeBuffer;
import org.apache.cassandra.spark.reader.ReaderUtils;
import org.apache.cassandra.spark.reader.RowData;
import org.apache.cassandra.spark.reader.StreamScanner;
import org.apache.cassandra.spark.reader.common.SSTableStreamException;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStreamScanner
implements StreamScanner<RowData>,
Closeable {
    private UnfilteredPartitionIterator allPartitions;
    private UnfilteredRowIterator partition;
    private Row staticRow;
    private Unfiltered unfiltered;
    private Iterator<ColumnData> columns;
    protected ColumnDataState columnData;
    @NotNull
    final TableMetadata metadata;
    @NotNull
    protected final TimeProvider timeProvider;
    protected final RowData rowData = new RowData();

    AbstractStreamScanner(@NotNull TableMetadata metadata, @NotNull Partitioner partitionerType, @NotNull TimeProvider timeProvider) {
        this.metadata = metadata.unbuild().partitioner((IPartitioner)(partitionerType == Partitioner.Murmur3Partitioner ? new Murmur3Partitioner() : new RandomPartitioner())).build();
        this.timeProvider = timeProvider;
        if (metadata.isCounter()) {
            throw new IllegalArgumentException(String.format("Streaming reads of SSTables from counter tables are not supported, rejecting stream of data from %s.%s", metadata.keyspace, metadata.name));
        }
    }

    public RowData data() {
        return this.rowData;
    }

    abstract UnfilteredPartitionIterator initializePartitions();

    @Override
    public abstract void close() throws IOException;

    protected abstract void handleRowTombstone(BigInteger var1, Row var2);

    protected abstract void handlePartitionTombstone(BigInteger var1, UnfilteredRowIterator var2);

    protected abstract void handleCellTombstone(BigInteger var1);

    protected abstract void handleCellTombstoneInComplex(BigInteger var1, Cell<?> var2);

    public void advanceToNextColumn() {
        this.columnData.consume();
    }

    public boolean hasMoreColumns() {
        return this.columns != null && this.columns.hasNext();
    }

    public boolean next() throws IOException {
        if (this.allPartitions == null) {
            this.allPartitions = this.initializePartitions();
        }
        while (true) {
            if (this.partition == null) {
                try {
                    BigInteger token;
                    if (this.allPartitions.hasNext()) {
                        this.partition = (UnfilteredRowIterator)this.allPartitions.next();
                        token = ReaderUtils.tokenToBigInteger((Token)this.partition.partitionKey().getToken());
                        if (!this.partition.partitionLevelDeletion().isLive()) {
                            this.handlePartitionTombstone(token, this.partition);
                            return true;
                        }
                    } else {
                        return false;
                    }
                    this.rowData.setPartitionKeyCopy(this.partition.partitionKey().getKey(), token);
                }
                catch (SSTableStreamException exception) {
                    throw exception.getIOException();
                }
                this.staticRow = this.partition.staticRow();
                if (!this.staticRow.isEmpty()) {
                    this.columns = this.staticRow.iterator();
                    this.prepareColumnData();
                    return true;
                }
            }
            if (this.columnData != null && this.columnData.hasData()) {
                return true;
            }
            if (this.columns != null && this.columns.hasNext()) {
                this.prepareColumnData();
                return true;
            }
            this.columns = null;
            try {
                if (this.partition.hasNext()) {
                    this.unfiltered = (Unfiltered)this.partition.next();
                } else {
                    this.partition = null;
                    this.unfiltered = null;
                }
            }
            catch (SSTableStreamException exception) {
                throw exception.getIOException();
            }
            if (this.unfiltered == null) continue;
            if (!this.unfiltered.isRow()) break;
            Row row = (Row)this.unfiltered;
            if (!row.deletion().isLive()) {
                this.handleRowTombstone(this.rowData.getToken(), row);
                return true;
            }
            if (!row.primaryKeyLivenessInfo().isEmpty()) {
                if (TableMetadata.Flag.isCQLTable((Set)this.metadata.flags)) {
                    this.columnData = new ClusteringColumnDataState((ClusteringPrefix)row.clustering());
                }
                this.columns = row.iterator();
                return true;
            }
            this.columns = row.iterator();
        }
        if (this.unfiltered.isRangeTombstoneMarker()) {
            throw new IllegalStateException("Encountered RangeTombstoneMarker. It should have been purged in CompactionIterator");
        }
        throw new IllegalStateException("Encountered unknown Unfiltered kind");
    }

    private void prepareColumnData() {
        ColumnData data = this.columns.next();
        this.columnData = data.column().isComplex() ? new ComplexDataState((ClusteringPrefix)(data.column().isStatic() ? Clustering.STATIC_CLUSTERING : this.unfiltered.clustering()), (ComplexColumnData)data) : new SimpleColumnDataState((ClusteringPrefix)(data.column().isStatic() ? Clustering.STATIC_CLUSTERING : this.unfiltered.clustering()), data);
    }

    private final class ComplexDataState
    implements ColumnDataState {
        private final ColumnMetadata column;
        private ClusteringPrefix clustering;
        private final Iterator<Cell<?>> cells;
        private final int cellCount;
        private final DeletionTime deletionTime;

        private ComplexDataState(ClusteringPrefix clustering, ComplexColumnData data) {
            this.clustering = clustering;
            this.column = data.column();
            this.cells = data.iterator();
            this.cellCount = data.cellsCount();
            this.deletionTime = data.complexDeletion();
        }

        @Override
        public boolean hasData() {
            return this.clustering != null && this.cells.hasNext();
        }

        @Override
        public void consume() {
            AbstractStreamScanner.this.rowData.setColumnNameCopy(ReaderUtils.encodeCellName(AbstractStreamScanner.this.metadata, this.clustering, this.column.name.bytes, ByteBufferUtil.EMPTY_BYTE_BUFFER));
            if (this.deletionTime.isLive()) {
                AbstractComplexTypeBuffer buffer = AbstractComplexTypeBuffer.newBuffer((AbstractType)this.column.type, (int)this.cellCount);
                long maxTimestamp = Long.MIN_VALUE;
                while (this.cells.hasNext()) {
                    Cell<?> cell = this.cells.next();
                    if (cell.isLive(AbstractStreamScanner.this.timeProvider.referenceEpochInSeconds())) {
                        buffer.addCell(cell);
                    } else {
                        AbstractStreamScanner.this.handleCellTombstoneInComplex(AbstractStreamScanner.this.rowData.getToken(), cell);
                    }
                    maxTimestamp = Math.max(maxTimestamp, cell.timestamp());
                }
                AbstractStreamScanner.this.rowData.setValueCopy(buffer.build());
                AbstractStreamScanner.this.rowData.setTimestamp(maxTimestamp);
            } else {
                AbstractStreamScanner.this.handleCellTombstone(AbstractStreamScanner.this.rowData.getToken());
                AbstractStreamScanner.this.rowData.setTimestamp(this.deletionTime.markedForDeleteAt());
            }
            this.clustering = null;
        }
    }

    private final class SimpleColumnDataState
    implements ColumnDataState {
        private ClusteringPrefix clustering;
        private final Cell cell;

        private SimpleColumnDataState(ClusteringPrefix clustering, ColumnData data) {
            Preconditions.checkArgument((boolean)data.column().isSimple(), (Object)"The type of the ColumnData should be simple");
            this.clustering = clustering;
            this.cell = (Cell)data;
        }

        @Override
        public boolean hasData() {
            return this.clustering != null;
        }

        @Override
        public void consume() {
            boolean isStatic = this.cell.column().isStatic();
            AbstractStreamScanner.this.rowData.setColumnNameCopy(ReaderUtils.encodeCellName(AbstractStreamScanner.this.metadata, (ClusteringPrefix)(isStatic ? Clustering.STATIC_CLUSTERING : this.clustering), this.cell.column().name.bytes, null));
            if (this.cell.isTombstone()) {
                AbstractStreamScanner.this.handleCellTombstone(AbstractStreamScanner.this.rowData.getToken());
            } else {
                AbstractStreamScanner.this.rowData.setValueCopy(this.cell.buffer());
            }
            AbstractStreamScanner.this.rowData.setTimestamp(this.cell.timestamp());
            this.clustering = null;
        }
    }

    protected final class ClusteringColumnDataState
    implements ColumnDataState {
        private boolean consumed = false;
        private final ClusteringPrefix clustering;

        ClusteringColumnDataState(ClusteringPrefix clustering) {
            this.clustering = clustering;
        }

        @Override
        public boolean hasData() {
            return !this.consumed;
        }

        @Override
        public void consume() {
            if (this.consumed) {
                throw new UnsupportedOperationException();
            }
            AbstractStreamScanner.this.rowData.setColumnNameCopy(ReaderUtils.encodeCellName(AbstractStreamScanner.this.metadata, this.clustering, ByteBufferUtil.EMPTY_BYTE_BUFFER, null));
            AbstractStreamScanner.this.rowData.setValueCopy(ByteBufferUtil.EMPTY_BYTE_BUFFER);
            this.consumed = true;
        }
    }

    private static interface ColumnDataState {
        public boolean hasData();

        public void consume();
    }
}

