/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.testing;

import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolvers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostResolver
implements DnsResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalhostResolver.class);
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^localhost(\\d+)?$");
    private final DnsResolver delegate;

    public LocalhostResolver() {
        this((DnsResolver)DnsResolvers.DEFAULT);
    }

    LocalhostResolver(DnsResolver delegate) {
        this.delegate = delegate;
    }

    public String resolve(String hostname) throws UnknownHostException {
        Matcher matcher = HOSTNAME_PATTERN.matcher(hostname);
        if (!matcher.matches()) {
            LOGGER.warn("Invalid hostname found {}.", (Object)hostname);
            return this.delegate.resolve(hostname);
        }
        String group = matcher.group(1);
        return "127.0.0." + (group != null ? group : "1");
    }

    public String reverseResolve(String address) throws UnknownHostException {
        int lastDotIndex = address.lastIndexOf(46);
        if (lastDotIndex < 0 || lastDotIndex + 1 == address.length()) {
            LOGGER.warn("Invalid ip address found {}.", (Object)address);
            return this.delegate.reverseResolve(address);
        }
        String netNumber = address.substring(lastDotIndex + 1);
        return "1".equals(netNumber) ? "localhost" : "localhost" + netNumber;
    }
}

