/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.spi.resolver;

import java.net.InetSocketAddress;
import o.a.c.sidecar.client.shaded.io.netty.resolver.AddressResolverGroup;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.Vertx;
import o.a.c.sidecar.client.shaded.io.vertx.core.VertxException;
import o.a.c.sidecar.client.shaded.io.vertx.core.dns.AddressResolverOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.VertxInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.logging.Logger;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.logging.LoggerFactory;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.resolver.DefaultResolverProvider;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.resolver.DnsResolverProvider;

public interface ResolverProvider {
    public static final String DISABLE_DNS_RESOLVER_PROP_NAME = "vertx.disableDnsResolver";

    public static ResolverProvider factory(Vertx vertx, AddressResolverOptions options) {
        try {
            if (!Boolean.getBoolean(DISABLE_DNS_RESOLVER_PROP_NAME)) {
                return DnsResolverProvider.create((VertxInternal)vertx, options);
            }
        }
        catch (Throwable e) {
            if (e instanceof VertxException) {
                throw e;
            }
            Logger logger = LoggerFactory.getLogger(ResolverProvider.class);
            logger.info("Using the default address resolver as the dns resolver could not be loaded");
        }
        return new DefaultResolverProvider();
    }

    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions var1);

    public void close(Handler<Void> var1);
}

