/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import io.netty.util.concurrent.FastThreadLocal;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.utils.Closeable;
import org.apache.cassandra.utils.WithResources;

public class ExecutorLocals
implements WithResources,
Closeable {
    private static final ExecutorLocals none = new ExecutorLocals(null, null);
    private static final FastThreadLocal<ExecutorLocals> locals = new FastThreadLocal<ExecutorLocals>(){

        @Override
        protected ExecutorLocals initialValue() {
            return none;
        }
    };
    public final TraceState traceState;
    public final ClientWarn.State clientWarnState;

    protected ExecutorLocals(TraceState traceState, ClientWarn.State clientWarnState) {
        this.traceState = traceState;
        this.clientWarnState = clientWarnState;
    }

    public static ExecutorLocals current() {
        return locals.get();
    }

    public static WithResources propagate() {
        ExecutorLocals locals = ExecutorLocals.current();
        return locals == none ? WithResources.none() : locals;
    }

    public static ExecutorLocals create(TraceState traceState) {
        ExecutorLocals current = locals.get();
        return current.traceState == traceState ? current : new ExecutorLocals(traceState, current.clientWarnState);
    }

    public static void clear() {
        locals.set(none);
    }

    @Override
    public Closeable get() {
        ExecutorLocals old = ExecutorLocals.current();
        if (old != this) {
            locals.set(this);
        }
        return old;
    }

    @Override
    public void close() {
        locals.set(this);
    }

    public static class Impl {
        protected static void set(TraceState traceState, ClientWarn.State clientWarnState) {
            if (traceState == null && clientWarnState == null) {
                locals.set(none);
            } else {
                locals.set(new ExecutorLocals(traceState, clientWarnState));
            }
        }
    }
}

