/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.repair;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.repair.CassandraValidationIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.TopPartitionTracker;
import org.apache.cassandra.repair.NoSuchRepairSessionException;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.repair.TableRepairManager;
import org.apache.cassandra.repair.ValidationPartitionIterator;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.TimeUUID;

public class CassandraTableRepairManager
implements TableRepairManager {
    private final ColumnFamilyStore cfs;
    private final SharedContext ctx;

    public CassandraTableRepairManager(ColumnFamilyStore cfs) {
        this(cfs, SharedContext.Global.instance);
    }

    public CassandraTableRepairManager(ColumnFamilyStore cfs, SharedContext ctx) {
        this.cfs = cfs;
        this.ctx = ctx;
    }

    @Override
    public ValidationPartitionIterator getValidationIterator(Collection<Range<Token>> ranges, TimeUUID parentId, TimeUUID sessionID, boolean isIncremental, long nowInSec, TopPartitionTracker.Collector topPartitionCollector) throws IOException, NoSuchRepairSessionException {
        return new CassandraValidationIterator(this.cfs, this.ctx, ranges, parentId, sessionID, isIncremental, nowInSec, topPartitionCollector);
    }

    @Override
    public Future<?> submitValidation(Callable<Object> validation) {
        return CompactionManager.instance.submitValidation(validation);
    }

    @Override
    public void incrementalSessionCompleted(TimeUUID sessionID) {
        CompactionManager.instance.submitBackground(this.cfs);
    }

    @Override
    public synchronized void snapshot(String name, final Collection<Range<Token>> ranges, boolean force) {
        try {
            ActiveRepairService.instance().snapshotExecutor.submit(() -> {
                if (force || !this.cfs.snapshotExists(name)) {
                    this.cfs.snapshot(name, new Predicate<SSTableReader>(){

                        @Override
                        public boolean apply(SSTableReader sstable) {
                            return sstable != null && !sstable.metadata().isIndex() && ((AbstractBounds)new Bounds<Token>(sstable.getFirst().getToken(), sstable.getLast().getToken())).intersects(ranges);
                        }
                    }, true, false);
                }
            }).get();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to take a snapshot %s on %s.%s", name, this.cfs.metadata.keyspace, this.cfs.metadata.name), ex);
        }
    }
}

