/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.db.tries.Trie;

class CollectionMergeTrie<T>
extends Trie<T> {
    private final Trie.CollectionMergeResolver<T> resolver;
    protected final Collection<? extends Trie<T>> inputs;

    CollectionMergeTrie(Collection<? extends Trie<T>> inputs, Trie.CollectionMergeResolver<T> resolver) {
        this.resolver = resolver;
        this.inputs = inputs;
    }

    @Override
    protected Trie.Cursor<T> cursor() {
        return new CollectionMergeCursor<T>(this.resolver, this.inputs);
    }

    static <T> boolean greaterCursor(Trie.Cursor<T> c1, Trie.Cursor<T> c2) {
        int c2depth;
        int c1depth = c1.depth();
        if (c1depth != (c2depth = c2.depth())) {
            return c1depth < c2depth;
        }
        return c1.incomingTransition() > c2.incomingTransition();
    }

    static <T> boolean equalCursor(Trie.Cursor<T> c1, Trie.Cursor<T> c2) {
        return c1.depth() == c2.depth() && c1.incomingTransition() == c2.incomingTransition();
    }

    static class Distinct<T>
    extends CollectionMergeTrie<T> {
        Distinct(Collection<? extends Trie<T>> inputs) {
            super(inputs, Distinct.throwingResolver());
        }

        @Override
        public Iterable<T> valuesUnordered() {
            return Iterables.concat(Iterables.transform(this.inputs, Trie::valuesUnordered));
        }
    }

    static class CollectionMergeCursor<T>
    implements Trie.Cursor<T> {
        private final Trie.CollectionMergeResolver<T> resolver;
        private Trie.Cursor<T> head;
        private final Trie.Cursor<T>[] heap;
        private final List<T> contents;

        public CollectionMergeCursor(Trie.CollectionMergeResolver<T> resolver, Collection<? extends Trie<T>> inputs) {
            this.resolver = resolver;
            int count = inputs.size();
            this.heap = new Trie.Cursor[count - 1];
            this.contents = new ArrayList<T>(count);
            int i = -1;
            for (Trie<T> trie : inputs) {
                Trie.Cursor<T> cursor = trie.cursor();
                assert (cursor.depth() == 0);
                if (i >= 0) {
                    this.heap[i] = cursor;
                } else {
                    this.head = cursor;
                }
                ++i;
            }
        }

        private void applyToEqualOnHeap(HeapOp<T> action) {
            this.applyToEqualElementsInHeap(action, 0);
        }

        private void advanceEqualAndRestoreHeap(AdvancingHeapOp<T> action) {
            this.applyToEqualElementsInHeap(action, 0);
        }

        private void applyToEqualElementsInHeap(HeapOp<T> action, int index) {
            if (index >= this.heap.length) {
                return;
            }
            Trie.Cursor<T> item = this.heap[index];
            if (!CollectionMergeTrie.equalCursor(item, this.head)) {
                return;
            }
            this.applyToEqualElementsInHeap(action, index * 2 + 1);
            this.applyToEqualElementsInHeap(action, index * 2 + 2);
            action.apply(this, item, index);
        }

        private void heapifyDown(Trie.Cursor<T> item, int index) {
            int next;
            while ((next = index * 2 + 1) < this.heap.length) {
                if (next + 1 < this.heap.length && CollectionMergeTrie.greaterCursor(this.heap[next], this.heap[next + 1])) {
                    ++next;
                }
                if (!CollectionMergeTrie.greaterCursor(item, this.heap[next])) break;
                this.heap[index] = this.heap[next];
                index = next;
            }
            this.heap[index] = item;
        }

        private int maybeSwapHead(int headDepth) {
            int heap0Depth = this.heap[0].depth();
            if (headDepth > heap0Depth || headDepth == heap0Depth && this.head.incomingTransition() <= this.heap[0].incomingTransition()) {
                return headDepth;
            }
            Trie.Cursor<T> newHeap0 = this.head;
            this.head = this.heap[0];
            this.heapifyDown(newHeap0, 0);
            return heap0Depth;
        }

        @Override
        public int advance() {
            this.advanceEqualAndRestoreHeap(Trie.Cursor::advance);
            return this.maybeSwapHead(this.head.advance());
        }

        @Override
        public int advanceMultiple(Trie.TransitionsReceiver receiver) {
            if (CollectionMergeTrie.equalCursor(this.heap[0], this.head)) {
                return this.advance();
            }
            return this.maybeSwapHead(this.head.advanceMultiple(receiver));
        }

        @Override
        public int skipChildren() {
            this.advanceEqualAndRestoreHeap(Trie.Cursor::skipChildren);
            return this.maybeSwapHead(this.head.skipChildren());
        }

        @Override
        public int depth() {
            return this.head.depth();
        }

        @Override
        public int incomingTransition() {
            return this.head.incomingTransition();
        }

        @Override
        public T content() {
            T toReturn;
            this.applyToEqualOnHeap(CollectionMergeCursor::collectContent);
            this.collectContent(this.head, -1);
            switch (this.contents.size()) {
                case 0: {
                    toReturn = null;
                    break;
                }
                case 1: {
                    toReturn = this.contents.get(0);
                    break;
                }
                default: {
                    toReturn = this.resolver.resolve(this.contents);
                }
            }
            this.contents.clear();
            return toReturn;
        }

        private void collectContent(Trie.Cursor<T> item, int index) {
            T itemContent = item.content();
            if (itemContent != null) {
                this.contents.add(itemContent);
            }
        }

        static interface AdvancingHeapOp<T>
        extends HeapOp<T> {
            public void apply(Trie.Cursor<T> var1);

            @Override
            default public void apply(CollectionMergeCursor<T> self, Trie.Cursor<T> cursor, int index) {
                this.apply(cursor);
                self.heapifyDown(cursor, index);
            }
        }

        static interface HeapOp<T> {
            public void apply(CollectionMergeCursor<T> var1, Trie.Cursor<T> var2, int var3);
        }
    }
}

