/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.format;

import com.google.common.base.Objects;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.OnDiskFormat;
import org.apache.cassandra.index.sai.disk.v1.V1OnDiskFormat;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.io.sstable.Component;

public class Version
implements Comparable<Version> {
    public static final String SAI_DESCRIPTOR = "SAI";
    public static final String SAI_SEPARATOR = "+";
    public static final Version AA = new Version("aa", V1OnDiskFormat.instance, (c, i) -> Version.defaultFileNameFormat(c, i, "aa"));
    public static final SortedSet<Version> ALL = new TreeSet<Version>(Comparator.reverseOrder()){
        {
            this.add(AA);
        }
    };
    public static final Version EARLIEST = AA;
    public static final Version LATEST = CassandraRelevantProperties.SAI_LATEST_VERSION.convert(Version::parse);
    private final String version;
    private final OnDiskFormat onDiskFormat;
    private final FileNameFormatter fileNameFormatter;

    private Version(String version, OnDiskFormat onDiskFormat, FileNameFormatter fileNameFormatter) {
        this.version = version;
        this.onDiskFormat = onDiskFormat;
        this.fileNameFormatter = fileNameFormatter;
    }

    public static Version parse(String versionString) {
        for (Version version : ALL) {
            if (!version.version.equals(versionString)) continue;
            return version;
        }
        throw new IllegalArgumentException("The version string " + versionString + " does not represent a valid SAI version. It should be one of " + ALL.stream().map(Version::toString).collect(Collectors.joining(", ")));
    }

    @Override
    public int compareTo(Version other) {
        return this.version.compareTo(other.version);
    }

    public int hashCode() {
        return Objects.hashCode(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version other = (Version)o;
        return Objects.equal(this.version, other.version);
    }

    public String toString() {
        return this.version;
    }

    public boolean onOrAfter(Version other) {
        return this.version.compareTo(other.version) >= 0;
    }

    public OnDiskFormat onDiskFormat() {
        return this.onDiskFormat;
    }

    public Component makePerSSTableComponent(IndexComponent indexComponent) {
        return indexComponent.type.createComponent(this.fileNameFormatter.format(indexComponent, null));
    }

    public Component makePerIndexComponent(IndexComponent indexComponent, IndexIdentifier indexIdentifier) {
        return indexComponent.type.createComponent(this.fileNameFormatter.format(indexComponent, indexIdentifier));
    }

    public FileNameFormatter fileNameFormatter() {
        return this.fileNameFormatter;
    }

    private static String defaultFileNameFormat(IndexComponent indexComponent, @Nullable IndexIdentifier indexIdentifier, String version) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SAI_DESCRIPTOR);
        stringBuilder.append(SAI_SEPARATOR).append(version);
        if (indexIdentifier != null) {
            stringBuilder.append(SAI_SEPARATOR).append(indexIdentifier.indexName);
        }
        stringBuilder.append(SAI_SEPARATOR).append(indexComponent.name);
        stringBuilder.append(".db");
        return stringBuilder.toString();
    }

    public static interface FileNameFormatter {
        public String format(IndexComponent var1, IndexIdentifier var2);
    }
}

