/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.metrics.QueryEventListener;

public final class MulticastQueryEventListeners {
    public static QueryEventListener.TrieIndexEventListener of(QueryContext ctx, QueryEventListener.TrieIndexEventListener listener) {
        return new Multicast2TrieIndexEventListener(ctx, listener);
    }

    public static QueryEventListener.BalancedTreeEventListener of(QueryContext ctx, QueryEventListener.BalancedTreeEventListener listener) {
        return new Multicast2BalancedTreeEventListener(ctx, listener);
    }

    public static class Multicast2TriePostingListEventListener
    implements QueryEventListener.PostingListEventListener {
        private final QueryContext ctx;
        private final QueryEventListener.PostingListEventListener listener;

        Multicast2TriePostingListEventListener(QueryContext ctx, QueryEventListener.PostingListEventListener listener) {
            this.ctx = ctx;
            this.listener = listener;
        }

        @Override
        public void onAdvance() {
            ++this.ctx.triePostingsSkips;
            this.listener.onAdvance();
        }

        @Override
        public void postingDecoded(long postingDecoded) {
            this.ctx.triePostingsDecodes += postingDecoded;
            this.listener.postingDecoded(postingDecoded);
        }
    }

    public static class Multicast2BalancedTreePostingListEventListener
    implements QueryEventListener.PostingListEventListener {
        private final QueryContext ctx;
        private final QueryEventListener.PostingListEventListener listener;

        Multicast2BalancedTreePostingListEventListener(QueryContext ctx, QueryEventListener.PostingListEventListener listener) {
            this.ctx = ctx;
            this.listener = listener;
        }

        @Override
        public void onAdvance() {
            ++this.ctx.balancedTreePostingsSkips;
            this.listener.onAdvance();
        }

        @Override
        public void postingDecoded(long postingDecoded) {
            this.ctx.balancedTreePostingsDecodes += postingDecoded;
            this.listener.postingDecoded(postingDecoded);
        }
    }

    public static class Multicast2BalancedTreeEventListener
    implements QueryEventListener.BalancedTreeEventListener {
        private final QueryContext ctx;
        private final QueryEventListener.BalancedTreeEventListener listener;
        private final Multicast2BalancedTreePostingListEventListener postingListEventListener;

        private Multicast2BalancedTreeEventListener(QueryContext ctx, QueryEventListener.BalancedTreeEventListener listener) {
            this.ctx = ctx;
            this.listener = listener;
            this.postingListEventListener = new Multicast2BalancedTreePostingListEventListener(ctx, listener.postingListEventListener());
        }

        @Override
        public void onIntersectionComplete(long intersectionTotalTime, TimeUnit unit) {
            this.listener.onIntersectionComplete(intersectionTotalTime, unit);
        }

        @Override
        public void onIntersectionEarlyExit() {
            this.listener.onIntersectionEarlyExit();
        }

        @Override
        public void postingListsHit(int count) {
            ++this.ctx.balancedTreePostingListsHit;
            this.listener.postingListsHit(count);
        }

        @Override
        public void onSegmentHit() {
            ++this.ctx.segmentsHit;
            ++this.ctx.balancedTreeSegmentsHit;
            this.listener.onSegmentHit();
        }

        @Override
        public QueryEventListener.PostingListEventListener postingListEventListener() {
            return this.postingListEventListener;
        }
    }

    public static class Multicast2TrieIndexEventListener
    implements QueryEventListener.TrieIndexEventListener {
        private final QueryContext ctx;
        private final QueryEventListener.TrieIndexEventListener listener;
        private final Multicast2TriePostingListEventListener postingListEventListener;

        private Multicast2TrieIndexEventListener(QueryContext ctx, QueryEventListener.TrieIndexEventListener listener) {
            this.ctx = ctx;
            this.listener = listener;
            this.postingListEventListener = new Multicast2TriePostingListEventListener(ctx, listener.postingListEventListener());
        }

        @Override
        public void onSegmentHit() {
            ++this.ctx.segmentsHit;
            ++this.ctx.trieSegmentsHit;
            this.listener.onSegmentHit();
        }

        @Override
        public void onTraversalComplete(long traversalTotalTime, TimeUnit unit) {
            this.listener.onTraversalComplete(traversalTotalTime, unit);
        }

        @Override
        public QueryEventListener.PostingListEventListener postingListEventListener() {
            return this.postingListEventListener;
        }
    }
}

