/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.io.sstable.IScrubber;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SortedTableScrubber;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.sstable.format.big.BigTableReader;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.OutputHandler;

public class BigTableScrubber
extends SortedTableScrubber<BigTableReader>
implements IScrubber {
    private final boolean isIndex;
    private final RandomAccessReader indexFile;
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    private ByteBuffer currentIndexKey;
    private ByteBuffer nextIndexKey;
    private long currentPartitionPositionFromIndex;
    private long nextPartitionPositionFromIndex;

    public BigTableScrubber(ColumnFamilyStore cfs, LifecycleTransaction transaction, OutputHandler outputHandler, IScrubber.Options options) {
        super(cfs, transaction, outputHandler, options);
        this.rowIndexEntrySerializer = new RowIndexEntry.Serializer(((BigTableReader)this.sstable).descriptor.version, ((BigTableReader)this.sstable).header, cfs.getMetrics());
        boolean hasIndexFile = ((BigTableReader)this.sstable).descriptor.fileFor(BigFormat.Components.PRIMARY_INDEX).exists();
        this.isIndex = cfs.isIndex();
        if (!hasIndexFile) {
            outputHandler.warn("Missing component: %s", ((BigTableReader)this.sstable).descriptor.fileFor(BigFormat.Components.PRIMARY_INDEX));
        }
        this.indexFile = hasIndexFile ? RandomAccessReader.open(((BigTableReader)this.sstable).descriptor.fileFor(BigFormat.Components.PRIMARY_INDEX)) : null;
        this.currentPartitionPositionFromIndex = 0L;
        this.nextPartitionPositionFromIndex = 0L;
    }

    @Override
    protected UnfilteredRowIterator withValidation(UnfilteredRowIterator iter2, String filename) {
        return this.options.checkData && !this.isIndex ? UnfilteredRowIterators.withValidation(iter2, filename) : iter2;
    }

    @Override
    protected void scrubInternal(SSTableRewriter writer) throws IOException {
        block21: {
            try {
                ByteBuffer byteBuffer = this.nextIndexKey = this.indexAvailable() ? ByteBufferUtil.readWithShortLength(this.indexFile) : null;
                if (this.indexAvailable()) {
                    long firstRowPositionFromIndex = this.rowIndexEntrySerializer.deserializePositionAndSkip(this.indexFile);
                    assert (firstRowPositionFromIndex == 0L) : firstRowPositionFromIndex;
                }
            }
            catch (Throwable ex) {
                BigTableScrubber.throwIfFatal(ex);
                this.nextIndexKey = null;
                this.nextPartitionPositionFromIndex = this.dataFile.length();
                if (this.indexFile == null) break block21;
                this.indexFile.seek(this.indexFile.length());
            }
        }
        DecoratedKey prevKey = null;
        while (!this.dataFile.isEOF()) {
            if (this.scrubInfo.isStopRequested()) {
                throw new CompactionInterruptedException(this.scrubInfo.getCompactionInfo());
            }
            long partitionStart = this.dataFile.getFilePointer();
            this.outputHandler.debug("Reading row at %d", partitionStart);
            DecoratedKey key = null;
            try {
                ByteBuffer raw = ByteBufferUtil.readWithShortLength(this.dataFile);
                if (!this.cfs.metadata.getLocal().isIndex()) {
                    this.cfs.metadata.getLocal().partitionKeyType.validate(raw);
                }
                key = ((BigTableReader)this.sstable).decorateKey(raw);
            }
            catch (Throwable th) {
                BigTableScrubber.throwIfFatal(th);
            }
            long dataStartFromIndex = -1L;
            long dataSizeFromIndex = -1L;
            this.updateIndexKey();
            if (this.indexAvailable() && this.currentIndexKey != null) {
                dataStartFromIndex = this.currentPartitionPositionFromIndex + 2L + (long)this.currentIndexKey.remaining();
                dataSizeFromIndex = this.nextPartitionPositionFromIndex - dataStartFromIndex;
            }
            long dataStart = this.dataFile.getFilePointer();
            String keyName = key == null ? "(unreadable key)" : this.keyString(key);
            this.outputHandler.debug("partition %s is %s", keyName, FBUtilities.prettyPrintMemory(dataSizeFromIndex));
            assert (this.currentIndexKey != null || !this.indexAvailable());
            try {
                if (key == null) {
                    throw new IOError(new IOException("Unable to read partition key from data file"));
                }
                if (this.currentIndexKey != null && !key.getKey().equals(this.currentIndexKey)) {
                    throw new IOError(new IOException(String.format("Key from data file (%s) does not match key from index file (%s)", "_too big_", ByteBufferUtil.bytesToHex(this.currentIndexKey))));
                }
                if (this.indexFile != null && dataSizeFromIndex > this.dataFile.length()) {
                    throw new IOError(new IOException("Impossible partition size (greater than file length): " + dataSizeFromIndex));
                }
                if (this.indexFile != null && dataStart != dataStartFromIndex) {
                    this.outputHandler.warn("Data file partition position %d differs from index file row position %d", dataStart, dataStartFromIndex);
                }
                if (!this.tryAppend(prevKey, key, writer)) continue;
                prevKey = key;
            }
            catch (Throwable th) {
                BigTableScrubber.throwIfFatal(th);
                this.outputHandler.warn(th, "Error reading partition %s (stacktrace follows):", keyName);
                if (!(this.currentIndexKey == null || key != null && key.getKey().equals(this.currentIndexKey) && dataStart == dataStartFromIndex)) {
                    this.outputHandler.output("Retrying from partition index; data is %s bytes starting at %s", dataSizeFromIndex, dataStartFromIndex);
                    key = ((BigTableReader)this.sstable).decorateKey(this.currentIndexKey);
                    try {
                        if (!this.cfs.metadata.getLocal().isIndex()) {
                            this.cfs.metadata.getLocal().partitionKeyType.validate(key.getKey());
                        }
                        this.dataFile.seek(dataStartFromIndex);
                        if (!this.tryAppend(prevKey, key, writer)) continue;
                        prevKey = key;
                        continue;
                    }
                    catch (Throwable th2) {
                        BigTableScrubber.throwIfFatal(th2);
                        this.throwIfCannotContinue(key, th2);
                        this.outputHandler.warn(th2, "Retry failed too. Skipping to next partition (retry's stacktrace follows)");
                        ++this.badPartitions;
                        if (this.seekToNextPartition()) continue;
                        break;
                    }
                }
                this.throwIfCannotContinue(key, th);
                this.outputHandler.warn("Partition starting at position %d is unreadable; skipping to next", dataStart);
                ++this.badPartitions;
                if (this.currentIndexKey == null || this.seekToNextPartition()) continue;
                break;
            }
        }
    }

    private void updateIndexKey() {
        this.currentIndexKey = this.nextIndexKey;
        this.currentPartitionPositionFromIndex = this.nextPartitionPositionFromIndex;
        try {
            this.nextIndexKey = !this.indexAvailable() ? null : ByteBufferUtil.readWithShortLength(this.indexFile);
            this.nextPartitionPositionFromIndex = !this.indexAvailable() ? this.dataFile.length() : this.rowIndexEntrySerializer.deserializePositionAndSkip(this.indexFile);
        }
        catch (Throwable th) {
            JVMStabilityInspector.inspectThrowable(th);
            this.outputHandler.warn(th, "Error reading index file");
            this.nextIndexKey = null;
            this.nextPartitionPositionFromIndex = this.dataFile.length();
        }
    }

    private boolean indexAvailable() {
        return this.indexFile != null && !this.indexFile.isEOF();
    }

    private boolean seekToNextPartition() {
        while (this.nextPartitionPositionFromIndex < this.dataFile.length()) {
            try {
                this.dataFile.seek(this.nextPartitionPositionFromIndex);
                return true;
            }
            catch (Throwable th) {
                BigTableScrubber.throwIfFatal(th);
                this.outputHandler.warn(th, "Failed to seek to next partition position %d", this.nextPartitionPositionFromIndex);
                ++this.badPartitions;
                this.updateIndexKey();
            }
        }
        return false;
    }

    @Override
    protected void throwIfCannotContinue(DecoratedKey key, Throwable th) {
        if (this.isIndex) {
            this.outputHandler.warn("An error occurred while scrubbing the partition with key '%s' for an index table. Scrubbing will abort for this table and the index will be rebuilt.", this.keyString(key));
            throw new IOError(th);
        }
        super.throwIfCannotContinue(key, th);
    }

    @Override
    public void close() {
        this.fileAccessLock.writeLock().lock();
        try {
            FileUtils.closeQuietly(this.dataFile);
            FileUtils.closeQuietly(this.indexFile);
        }
        finally {
            this.fileAccessLock.writeLock().unlock();
        }
    }
}

