/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.tries;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.tries.SerializationNode;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.SizedInts;

public abstract class TrieNode {
    public static final int NONE = -1;
    final int bytesPerPointer;
    static final int FRACTIONAL_BYTES = 0;
    final int ordinal;

    public static TrieNode at(ByteBuffer src, int position) {
        return Types.values[src.get(position) >> 4 & 0xF];
    }

    public int payloadFlags(ByteBuffer src, int position) {
        return src.get(position) & 0xF;
    }

    public abstract int payloadPosition(ByteBuffer var1, int var2);

    public abstract int search(ByteBuffer var1, int var2, int var3);

    public abstract int transitionRange(ByteBuffer var1, int var2);

    public abstract int transitionByte(ByteBuffer var1, int var2, int var3);

    abstract long transitionDelta(ByteBuffer var1, int var2, int var3);

    public long transition(ByteBuffer src, int position, long positionLong, int childIndex) {
        return positionLong + this.transitionDelta(src, position, childIndex);
    }

    public long lastTransition(ByteBuffer src, int position, long positionLong) {
        return this.transition(src, position, positionLong, this.transitionRange(src, position) - 1);
    }

    public abstract long greaterTransition(ByteBuffer var1, int var2, long var3, int var5, long var6);

    public abstract long lesserTransition(ByteBuffer var1, int var2, long var3, int var5, long var6);

    public static TrieNode typeFor(SerializationNode<?> node, long nodePosition) {
        int c = node.childCount();
        if (c == 0) {
            return Types.PAYLOAD_ONLY;
        }
        int bitsPerPointerIndex = 0;
        long delta = node.maxPositionDelta(nodePosition);
        assert (delta < 0L);
        while (!Types.singles[bitsPerPointerIndex].fits(-delta)) {
            ++bitsPerPointerIndex;
        }
        if (c == 1) {
            if (node.payload() != null && Types.singles[bitsPerPointerIndex].bytesPerPointer == 0) {
                ++bitsPerPointerIndex;
            }
            return Types.singles[bitsPerPointerIndex];
        }
        TrieNode sparse = Types.sparses[bitsPerPointerIndex];
        TrieNode dense = Types.denses[bitsPerPointerIndex];
        return sparse.sizeofNode(node) < dense.sizeofNode(node) ? sparse : dense;
    }

    public abstract int sizeofNode(SerializationNode<?> var1);

    public abstract void serialize(DataOutputPlus var1, SerializationNode<?> var2, int var3, long var4) throws IOException;

    TrieNode(int ordinal, int bytesPerPointer) {
        this.ordinal = ordinal;
        this.bytesPerPointer = bytesPerPointer;
    }

    static int read12Bits(ByteBuffer src, int base, int searchIndex) {
        int word = src.getShort(base + 3 * searchIndex / 2);
        if ((searchIndex & 1) == 0) {
            word >>= 4;
        }
        return word & 0xFFF;
    }

    static int write12Bits(DataOutput dest, int value, int index, int carry) throws IOException {
        assert (0 <= value && value <= 4095);
        if ((index & 1) == 0) {
            dest.writeByte(value >> 4);
            return value << 4;
        }
        dest.writeByte(carry | value >> 8);
        dest.writeByte(value);
        return 0;
    }

    long readBytes(ByteBuffer src, int position) {
        return SizedInts.readUnsigned(src, position, this.bytesPerPointer);
    }

    void writeBytes(DataOutputPlus dest, long ofs) throws IOException {
        assert (this.fits(ofs));
        SizedInts.write(dest, ofs, this.bytesPerPointer);
    }

    boolean fits(long delta) {
        return 0L <= delta && delta < 1L << this.bytesPerPointer * 8;
    }

    public String toString() {
        Object res = this.getClass().getSimpleName();
        if (this.bytesPerPointer >= 1) {
            res = (String)res + this.bytesPerPointer * 8;
        }
        return res;
    }

    static class Types {
        static final TrieNode PAYLOAD_ONLY = new PayloadOnly(0);
        static final TrieNode SINGLE_NOPAYLOAD_4 = new SingleNoPayload4(1);
        static final TrieNode SINGLE_8 = new Single(2, 1);
        static final TrieNode SINGLE_NOPAYLOAD_12 = new SingleNoPayload12(3);
        static final TrieNode SINGLE_16 = new Single(4, 2);
        static final TrieNode SPARSE_8 = new Sparse(5, 1);
        static final TrieNode SPARSE_12 = new Sparse12(6);
        static final TrieNode SPARSE_16 = new Sparse(7, 2);
        static final TrieNode SPARSE_24 = new Sparse(8, 3);
        static final TrieNode SPARSE_40 = new Sparse(9, 5);
        static final TrieNode DENSE_12 = new Dense12(10);
        static final TrieNode DENSE_16 = new Dense(11, 2);
        static final TrieNode DENSE_24 = new Dense(12, 3);
        static final TrieNode DENSE_32 = new Dense(13, 4);
        static final TrieNode DENSE_40 = new Dense(14, 5);
        static final TrieNode LONG_DENSE = new LongDense(15);
        static final TrieNode[] values = new TrieNode[]{PAYLOAD_ONLY, SINGLE_NOPAYLOAD_4, SINGLE_8, SINGLE_NOPAYLOAD_12, SINGLE_16, SPARSE_8, SPARSE_12, SPARSE_16, SPARSE_24, SPARSE_40, DENSE_12, DENSE_16, DENSE_24, DENSE_32, DENSE_40, LONG_DENSE};
        static final TrieNode[] singles = new TrieNode[]{SINGLE_NOPAYLOAD_4, SINGLE_8, SINGLE_NOPAYLOAD_12, SINGLE_16, DENSE_24, DENSE_32, DENSE_40, LONG_DENSE};
        static final TrieNode[] sparses = new TrieNode[]{SPARSE_8, SPARSE_8, SPARSE_12, SPARSE_16, SPARSE_24, SPARSE_40, SPARSE_40, LONG_DENSE};
        static final TrieNode[] denses = new TrieNode[]{DENSE_12, DENSE_12, DENSE_12, DENSE_16, DENSE_24, DENSE_32, DENSE_40, LONG_DENSE};

        Types() {
        }

        static {
            assert (sparses.length == singles.length && denses.length == singles.length && values.length <= 16);
            for (int i = 0; i < values.length; ++i) {
                assert (Types.values[i].ordinal == i);
            }
        }
    }

    private static class LongDense
    extends Dense {
        LongDense(int ordinal) {
            super(ordinal, 8);
        }

        @Override
        public long transitionDelta(ByteBuffer src, int position, int childIndex) {
            return -src.getLong(position + 3 + childIndex * 8);
        }

        @Override
        public void writeBytes(DataOutputPlus dest, long ofs) throws IOException {
            dest.writeLong(ofs);
        }

        @Override
        boolean fits(long delta) {
            return true;
        }
    }

    private static class Dense12
    extends Dense {
        Dense12(int ordinal) {
            super(ordinal, 0);
        }

        @Override
        public int payloadPosition(ByteBuffer src, int position) {
            return position + 3 + (this.transitionRange(src, position) * 3 + 1) / 2;
        }

        @Override
        public long transitionDelta(ByteBuffer src, int position, int childIndex) {
            return -Dense12.read12Bits(src, position + 3, childIndex);
        }

        @Override
        public int sizeofNode(SerializationNode<?> node) {
            int l = node.transition(0);
            int r = node.transition(node.childCount() - 1);
            return 3 + ((r - l + 1) * 3 + 1) / 2;
        }

        @Override
        public void serialize(DataOutputPlus dest, SerializationNode<?> node, int payloadBits, long nodePosition) throws IOException {
            int childCount = node.childCount();
            dest.writeByte((this.ordinal << 4) + (payloadBits & 0xF));
            int l = node.transition(0);
            int r = node.transition(childCount - 1);
            assert (0 <= l && l <= r && r <= 255);
            dest.writeByte(l);
            dest.writeByte(r - l);
            int carry = 0;
            int start = l;
            for (int i = 0; i < childCount; ++i) {
                int next = node.transition(i);
                while (l < next) {
                    carry = Dense12.write12Bits(dest, 0, l - start, carry);
                    ++l;
                }
                long pd = node.serializedPositionDelta(i, nodePosition);
                carry = Dense12.write12Bits(dest, (int)(-pd), l - start, carry);
                ++l;
            }
            if ((l - start & 1) == 1) {
                dest.writeByte(carry);
            }
        }

        @Override
        boolean fits(long delta) {
            return 0L <= delta && delta <= 4095L;
        }
    }

    private static class Dense
    extends TrieNode {
        static final int NULL_VALUE = 0;

        Dense(int ordinal, int bytesPerPointer) {
            super(ordinal, bytesPerPointer);
        }

        @Override
        public int transitionRange(ByteBuffer src, int position) {
            return 1 + (src.get(position + 2) & 0xFF);
        }

        @Override
        public int payloadPosition(ByteBuffer src, int position) {
            return position + 3 + this.transitionRange(src, position) * this.bytesPerPointer;
        }

        @Override
        public int search(ByteBuffer src, int position, int transitionByte) {
            int l = src.get(position + 1) & 0xFF;
            int i = transitionByte - l;
            if (i < 0) {
                return -1;
            }
            int len = this.transitionRange(src, position);
            if (i >= len) {
                return -len - 1;
            }
            long t2 = this.transition(src, position, 0L, i);
            return t2 != -1L ? i : -i - 1;
        }

        @Override
        public long transitionDelta(ByteBuffer src, int position, int childIndex) {
            return -this.readBytes(src, position + 3 + childIndex * this.bytesPerPointer);
        }

        @Override
        public long transition(ByteBuffer src, int position, long positionLong, int childIndex) {
            long v = this.transitionDelta(src, position, childIndex);
            return v != 0L ? v + positionLong : -1L;
        }

        @Override
        public long greaterTransition(ByteBuffer src, int position, long positionLong, int searchIndex, long defaultValue) {
            searchIndex = searchIndex < 0 ? -1 - searchIndex : ++searchIndex;
            int len = this.transitionRange(src, position);
            while (searchIndex < len) {
                long t2 = this.transition(src, position, positionLong, searchIndex);
                if (t2 != -1L) {
                    return t2;
                }
                ++searchIndex;
            }
            return defaultValue;
        }

        @Override
        public long lesserTransition(ByteBuffer src, int position, long positionLong, int searchIndex, long defaultValue) {
            if (searchIndex == 0 || searchIndex == -1) {
                return defaultValue;
            }
            searchIndex = searchIndex < 0 ? -2 - searchIndex : --searchIndex;
            while (searchIndex >= 0) {
                long t2 = this.transition(src, position, positionLong, searchIndex);
                if (t2 != -1L) {
                    return t2;
                }
                --searchIndex;
            }
            assert (false) : "transition must always exist at 0, and we should not be called for less of that";
            return defaultValue;
        }

        @Override
        public int transitionByte(ByteBuffer src, int position, int childIndex) {
            if (childIndex >= this.transitionRange(src, position)) {
                return Integer.MAX_VALUE;
            }
            int l = src.get(position + 1) & 0xFF;
            return l + childIndex;
        }

        @Override
        public int sizeofNode(SerializationNode<?> node) {
            int l = node.transition(0);
            int r = node.transition(node.childCount() - 1);
            return 3 + (r - l + 1) * this.bytesPerPointer;
        }

        @Override
        public void serialize(DataOutputPlus dest, SerializationNode<?> node, int payloadBits, long nodePosition) throws IOException {
            int childCount = node.childCount();
            dest.writeByte((this.ordinal << 4) + (payloadBits & 0xF));
            int l = node.transition(0);
            int r = node.transition(childCount - 1);
            assert (0 <= l && l <= r && r <= 255);
            dest.writeByte(l);
            dest.writeByte(r - l);
            for (int i = 0; i < childCount; ++i) {
                int next = node.transition(i);
                while (l < next) {
                    this.writeBytes(dest, 0L);
                    ++l;
                }
                this.writeBytes(dest, -node.serializedPositionDelta(i, nodePosition));
                ++l;
            }
        }
    }

    private static class Sparse12
    extends Sparse {
        Sparse12(int ordinal) {
            super(ordinal, 0);
        }

        @Override
        public int payloadPosition(ByteBuffer src, int position) {
            int count = this.transitionRange(src, position);
            return position + 2 + (5 * count + 1) / 2;
        }

        @Override
        public long transitionDelta(ByteBuffer src, int position, int childIndex) {
            return -Sparse12.read12Bits(src, position + 2 + this.transitionRange(src, position), childIndex);
        }

        @Override
        public int sizeofNode(SerializationNode<?> node) {
            return 2 + (node.childCount() * 5 + 1) / 2;
        }

        @Override
        public void serialize(DataOutputPlus dest, SerializationNode<?> node, int payloadBits, long nodePosition) throws IOException {
            int i;
            int childCount = node.childCount();
            assert (childCount < 256);
            dest.writeByte((this.ordinal << 4) + (payloadBits & 0xF));
            dest.writeByte(childCount);
            for (i = 0; i < childCount; ++i) {
                dest.writeByte(node.transition(i));
            }
            i = 0;
            while (i + 2 <= childCount) {
                int p0 = (int)(-node.serializedPositionDelta(i, nodePosition));
                int p1 = (int)(-node.serializedPositionDelta(i + 1, nodePosition));
                assert (p0 > 0 && p0 < 4096);
                assert (p1 > 0 && p1 < 4096);
                dest.writeByte(p0 >> 4);
                dest.writeByte(p0 << 4 | p1 >> 8);
                dest.writeByte(p1);
                i += 2;
            }
            if (i < childCount) {
                long pd = -node.serializedPositionDelta(i, nodePosition);
                assert (pd > 0L && pd < 4096L);
                dest.writeShort((short)(pd << 4));
            }
        }

        @Override
        boolean fits(long delta) {
            return 0L <= delta && delta <= 4095L;
        }
    }

    private static class Sparse
    extends TrieNode {
        Sparse(int ordinal, int bytesPerPointer) {
            super(ordinal, bytesPerPointer);
        }

        @Override
        public int transitionRange(ByteBuffer src, int position) {
            return src.get(position + 1) & 0xFF;
        }

        @Override
        public int payloadPosition(ByteBuffer src, int position) {
            int count = this.transitionRange(src, position);
            return position + 2 + (this.bytesPerPointer + 1) * count;
        }

        @Override
        public int search(ByteBuffer src, int position, int key) {
            int l = -1;
            int r = this.transitionRange(src, position);
            position += 2;
            while (l + 1 < r) {
                int m4 = (l + r + 1) / 2;
                int childTransition = src.get(position + m4) & 0xFF;
                int cmp = Integer.compare(key, childTransition);
                if (cmp < 0) {
                    r = m4;
                    continue;
                }
                if (cmp > 0) {
                    l = m4;
                    continue;
                }
                return m4;
            }
            return -r - 1;
        }

        @Override
        public long transitionDelta(ByteBuffer src, int position, int childIndex) {
            assert (childIndex >= 0);
            int range = this.transitionRange(src, position);
            assert (childIndex < range);
            return -this.readBytes(src, position + 2 + range + this.bytesPerPointer * childIndex);
        }

        @Override
        public long greaterTransition(ByteBuffer src, int position, long positionLong, int searchIndex, long defaultValue) {
            searchIndex = searchIndex < 0 ? -1 - searchIndex : ++searchIndex;
            if (searchIndex >= this.transitionRange(src, position)) {
                return defaultValue;
            }
            return this.transition(src, position, positionLong, searchIndex);
        }

        @Override
        public long lesserTransition(ByteBuffer src, int position, long positionLong, int searchIndex, long defaultValue) {
            if (searchIndex == 0 || searchIndex == -1) {
                return defaultValue;
            }
            searchIndex = searchIndex < 0 ? -2 - searchIndex : --searchIndex;
            return this.transition(src, position, positionLong, searchIndex);
        }

        @Override
        public int transitionByte(ByteBuffer src, int position, int childIndex) {
            return childIndex < this.transitionRange(src, position) ? src.get(position + 2 + childIndex) & 0xFF : Integer.MAX_VALUE;
        }

        @Override
        public int sizeofNode(SerializationNode<?> node) {
            return 2 + node.childCount() * (1 + this.bytesPerPointer);
        }

        @Override
        public void serialize(DataOutputPlus dest, SerializationNode<?> node, int payloadBits, long nodePosition) throws IOException {
            int i;
            int childCount = node.childCount();
            assert (childCount > 0);
            assert (childCount < 256);
            dest.writeByte((this.ordinal << 4) + (payloadBits & 0xF));
            dest.writeByte(childCount);
            for (i = 0; i < childCount; ++i) {
                dest.writeByte(node.transition(i));
            }
            for (i = 0; i < childCount; ++i) {
                this.writeBytes(dest, -node.serializedPositionDelta(i, nodePosition));
            }
        }
    }

    private static class SingleNoPayload12
    extends Single {
        SingleNoPayload12(int ordinal) {
            super(ordinal, 0);
        }

        @Override
        public int payloadFlags(ByteBuffer src, int position) {
            return 0;
        }

        @Override
        public int payloadPosition(ByteBuffer src, int position) {
            return position + 3;
        }

        @Override
        public int search(ByteBuffer src, int position, int transitionByte) {
            int c = src.get(position + 2) & 0xFF;
            if (transitionByte == c) {
                return 0;
            }
            return transitionByte < c ? -1 : -2;
        }

        @Override
        public long transitionDelta(ByteBuffer src, int position, int childIndex) {
            return -(src.getShort(position) & 0xFFF);
        }

        @Override
        public int transitionByte(ByteBuffer src, int position, int childIndex) {
            return childIndex == 0 ? src.get(position + 2) & 0xFF : Integer.MAX_VALUE;
        }

        @Override
        boolean fits(long delta) {
            return 0L <= delta && delta <= 4095L;
        }

        @Override
        public void serialize(DataOutputPlus dest, SerializationNode<?> node, int payloadBits, long nodePosition) throws IOException {
            assert (payloadBits == 0);
            int childCount = node.childCount();
            assert (childCount == 1);
            long pd = -node.serializedPositionDelta(0, nodePosition);
            assert (pd > 0L && pd < 4096L);
            dest.writeByte((this.ordinal << 4) + (int)(pd >> 8 & 0xFL));
            dest.writeByte((byte)pd);
            dest.writeByte(node.transition(0));
        }

        @Override
        public int sizeofNode(SerializationNode<?> node) {
            return 3;
        }
    }

    private static class SingleNoPayload4
    extends Single {
        SingleNoPayload4(int ordinal) {
            super(ordinal, 0);
        }

        @Override
        public int payloadFlags(ByteBuffer src, int position) {
            return 0;
        }

        @Override
        public int payloadPosition(ByteBuffer src, int position) {
            return position + 2;
        }

        @Override
        public long transitionDelta(ByteBuffer src, int position, int childIndex) {
            return -(src.get(position) & 0xF);
        }

        @Override
        boolean fits(long delta) {
            return 0L <= delta && delta <= 15L;
        }

        @Override
        public void serialize(DataOutputPlus dest, SerializationNode<?> node, int payloadBits, long nodePosition) throws IOException {
            assert (payloadBits == 0);
            int childCount = node.childCount();
            assert (childCount == 1);
            long pd = -node.serializedPositionDelta(0, nodePosition);
            assert (pd > 0L && pd < 16L);
            dest.writeByte((this.ordinal << 4) + (int)(pd & 0xFL));
            dest.writeByte(node.transition(0));
        }

        @Override
        public int sizeofNode(SerializationNode<?> node) {
            return 2;
        }
    }

    private static class Single
    extends TrieNode {
        Single(int ordinal, int bytesPerPointer) {
            super(ordinal, bytesPerPointer);
        }

        @Override
        public int payloadPosition(ByteBuffer src, int position) {
            return position + 2 + this.bytesPerPointer;
        }

        @Override
        public int search(ByteBuffer src, int position, int transitionByte) {
            int c = src.get(position + 1) & 0xFF;
            if (transitionByte == c) {
                return 0;
            }
            return transitionByte < c ? -1 : -2;
        }

        @Override
        public long transitionDelta(ByteBuffer src, int position, int childIndex) {
            return -this.readBytes(src, position + 2);
        }

        @Override
        public long lastTransition(ByteBuffer src, int position, long positionLong) {
            return this.transition(src, position, positionLong, 0);
        }

        @Override
        public long greaterTransition(ByteBuffer src, int position, long positionLong, int searchIndex, long defaultValue) {
            return searchIndex == -1 ? this.transition(src, position, positionLong, 0) : defaultValue;
        }

        @Override
        public long lesserTransition(ByteBuffer src, int position, long positionLong, int searchIndex, long defaultValue) {
            return searchIndex == 0 || searchIndex == -1 ? defaultValue : this.transition(src, position, positionLong, 0);
        }

        @Override
        public int transitionByte(ByteBuffer src, int position, int childIndex) {
            return childIndex == 0 ? src.get(position + 1) & 0xFF : Integer.MAX_VALUE;
        }

        @Override
        public int transitionRange(ByteBuffer src, int position) {
            return 1;
        }

        @Override
        public int sizeofNode(SerializationNode<?> node) {
            return 2 + this.bytesPerPointer;
        }

        @Override
        public void serialize(DataOutputPlus dest, SerializationNode<?> node, int payloadBits, long nodePosition) throws IOException {
            int childCount = node.childCount();
            assert (childCount == 1);
            dest.writeByte((this.ordinal << 4) + (payloadBits & 0xF));
            dest.writeByte(node.transition(0));
            this.writeBytes(dest, -node.serializedPositionDelta(0, nodePosition));
        }
    }

    private static class PayloadOnly
    extends TrieNode {
        PayloadOnly(int ordinal) {
            super(ordinal, 0);
        }

        @Override
        public int payloadPosition(ByteBuffer src, int position) {
            return position + 1;
        }

        @Override
        public int search(ByteBuffer src, int position, int transitionByte) {
            return -1;
        }

        @Override
        public long transitionDelta(ByteBuffer src, int position, int childIndex) {
            return 0L;
        }

        @Override
        public long transition(ByteBuffer src, int position, long positionLong, int childIndex) {
            return -1L;
        }

        @Override
        public long lastTransition(ByteBuffer src, int position, long positionLong) {
            return -1L;
        }

        @Override
        public long greaterTransition(ByteBuffer src, int position, long positionLong, int searchIndex, long defaultValue) {
            return defaultValue;
        }

        @Override
        public long lesserTransition(ByteBuffer src, int position, long positionLong, int searchIndex, long defaultValue) {
            return defaultValue;
        }

        @Override
        public int transitionByte(ByteBuffer src, int position, int childIndex) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int transitionRange(ByteBuffer src, int position) {
            return 0;
        }

        @Override
        public int sizeofNode(SerializationNode<?> node) {
            return 1;
        }

        @Override
        public void serialize(DataOutputPlus dest, SerializationNode<?> node, int payloadBits, long nodePosition) throws IOException {
            dest.writeByte((this.ordinal << 4) + (payloadBits & 0xF));
        }
    }
}

