/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.metrics.CacheMetrics;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;

public class ChunkCacheMetrics
extends CacheMetrics
implements StatsCounter {
    public final Timer missLatency;

    public ChunkCacheMetrics(ChunkCache cache) {
        super("ChunkCache", cache);
        this.missLatency = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName("MissLatency"));
    }

    @Override
    public void recordHits(int count) {
        this.requests.mark(count);
        this.hits.mark(count);
    }

    @Override
    public void recordMisses(int count) {
        this.requests.mark(count);
        this.misses.mark(count);
    }

    @Override
    public void recordLoadSuccess(long loadTime) {
        this.missLatency.update(loadTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordLoadFailure(long loadTime) {
    }

    @Override
    public void recordEviction(int weight, RemovalCause cause) {
    }

    @Override
    @Nonnull
    public CacheStats snapshot() {
        return CacheStats.of(this.hits.getCount(), this.misses.getCount(), this.missLatency.getCount(), 0L, this.missLatency.getCount(), 0L, 0L);
    }
}

