/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DoubleSerializer
extends TypeSerializer<Double> {
    public static final DoubleSerializer instance = new DoubleSerializer();

    @Override
    public <V> Double deserialize(V value, ValueAccessor<V> accessor) {
        if (accessor.isEmpty(value)) {
            return null;
        }
        return accessor.toDouble(value);
    }

    @Override
    public ByteBuffer serialize(Double value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    @Override
    public <T> void validate(T value, ValueAccessor<T> accessor) throws MarshalException {
        if (accessor.size(value) != 8 && !accessor.isEmpty(value)) {
            throw new MarshalException(String.format("Expected 8 or 0 byte value for a double (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(Double value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Class<Double> getType() {
        return Double.class;
    }
}

