/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.aggregation.GroupingState;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.transport.Dispatcher;

public final class AggregationQueryPager
implements QueryPager {
    private final DataLimits limits;
    private QueryPager subPager;

    public AggregationQueryPager(QueryPager subPager, DataLimits limits) {
        this.subPager = subPager;
        this.limits = limits;
    }

    @Override
    public PartitionIterator fetchPage(int pageSize, ConsistencyLevel consistency, ClientState clientState, Dispatcher.RequestTime requestTime) {
        if (this.limits.isGroupByLimit()) {
            return new GroupByPartitionIterator(pageSize, consistency, clientState, requestTime);
        }
        return new AggregationPartitionIterator(pageSize, consistency, clientState, requestTime);
    }

    @Override
    public ReadExecutionController executionController() {
        return this.subPager.executionController();
    }

    @Override
    public PartitionIterator fetchPageInternal(int pageSize, ReadExecutionController executionController) {
        if (this.limits.isGroupByLimit()) {
            return new GroupByPartitionIterator(pageSize, executionController, Dispatcher.RequestTime.forImmediateExecution());
        }
        return new AggregationPartitionIterator(pageSize, executionController, Dispatcher.RequestTime.forImmediateExecution());
    }

    @Override
    public boolean isExhausted() {
        return this.subPager.isExhausted();
    }

    @Override
    public int maxRemaining() {
        return this.subPager.maxRemaining();
    }

    @Override
    public PagingState state() {
        return this.subPager.state();
    }

    @Override
    public QueryPager withUpdatedLimit(DataLimits newLimits) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTopK() {
        return this.subPager.isTopK();
    }

    public final class AggregationPartitionIterator
    extends GroupByPartitionIterator {
        public AggregationPartitionIterator(int pageSize, ConsistencyLevel consistency, ClientState clientState, Dispatcher.RequestTime requestTime) {
            super(pageSize, consistency, clientState, requestTime);
        }

        public AggregationPartitionIterator(int pageSize, ReadExecutionController executionController, Dispatcher.RequestTime requestTime) {
            super(pageSize, executionController, requestTime);
        }

        @Override
        protected QueryPager updatePagerLimit(QueryPager pager, DataLimits limits, ByteBuffer lastPartitionKey, Clustering<?> lastClustering) {
            return pager;
        }

        @Override
        protected boolean isDone(int pageSize, int counted) {
            return false;
        }

        @Override
        protected int computeSubPageSize(int pageSize, int counted) {
            return pageSize;
        }
    }

    public class GroupByPartitionIterator
    implements PartitionIterator {
        private final int pageSize;
        private final ConsistencyLevel consistency;
        private final ClientState clientState;
        private final ReadExecutionController executionController;
        private PartitionIterator partitionIterator;
        private RowIterator next;
        private boolean endOfData;
        private boolean closed;
        private ByteBuffer lastPartitionKey;
        private Clustering<?> lastClustering;
        private int initialMaxRemaining;
        private Dispatcher.RequestTime requestTime;

        public GroupByPartitionIterator(int pageSize, ConsistencyLevel consistency, ClientState clientState, Dispatcher.RequestTime requestTime) {
            this(pageSize, consistency, clientState, null, requestTime);
        }

        public GroupByPartitionIterator(int pageSize, ReadExecutionController executionController, Dispatcher.RequestTime requestTime) {
            this(pageSize, null, null, executionController, requestTime);
        }

        private GroupByPartitionIterator(int pageSize, ConsistencyLevel consistency, ClientState clientState, ReadExecutionController executionController, Dispatcher.RequestTime requestTime) {
            this.pageSize = this.handlePagingOff(pageSize);
            this.consistency = consistency;
            this.clientState = clientState;
            this.executionController = executionController;
            this.requestTime = requestTime;
        }

        private int handlePagingOff(int pageSize) {
            return pageSize <= 0 ? Integer.MAX_VALUE : pageSize;
        }

        @Override
        public final void close() {
            if (!this.closed) {
                this.closed = true;
                this.partitionIterator.close();
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.endOfData) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            this.fetchNextRowIterator();
            return this.next != null;
        }

        private void fetchNextRowIterator() {
            if (this.partitionIterator == null) {
                this.initialMaxRemaining = AggregationQueryPager.this.subPager.maxRemaining();
                this.partitionIterator = this.fetchSubPage(this.pageSize);
            }
            while (!this.partitionIterator.hasNext()) {
                this.partitionIterator.close();
                int counted = this.initialMaxRemaining - AggregationQueryPager.this.subPager.maxRemaining();
                if (this.isDone(this.pageSize, counted) || AggregationQueryPager.this.subPager.isExhausted()) {
                    this.endOfData = true;
                    this.closed = true;
                    return;
                }
                AggregationQueryPager.this.subPager = this.updatePagerLimit(AggregationQueryPager.this.subPager, AggregationQueryPager.this.limits, this.lastPartitionKey, this.lastClustering);
                this.partitionIterator = this.fetchSubPage(this.computeSubPageSize(this.pageSize, counted));
            }
            this.next = (RowIterator)this.partitionIterator.next();
        }

        protected boolean isDone(int pageSize, int counted) {
            return counted == pageSize;
        }

        protected QueryPager updatePagerLimit(QueryPager pager, DataLimits limits, ByteBuffer lastPartitionKey, Clustering<?> lastClustering) {
            GroupingState state = new GroupingState(lastPartitionKey, lastClustering);
            DataLimits newLimits = limits.forGroupByInternalPaging(state);
            return pager.withUpdatedLimit(newLimits);
        }

        protected int computeSubPageSize(int pageSize, int counted) {
            return pageSize - counted;
        }

        private final PartitionIterator fetchSubPage(int subPageSize) {
            return this.consistency != null ? AggregationQueryPager.this.subPager.fetchPage(subPageSize, this.consistency, this.clientState, this.requestTime) : AggregationQueryPager.this.subPager.fetchPageInternal(subPageSize, this.executionController);
        }

        @Override
        public final RowIterator next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            GroupByRowIterator iterator = new GroupByRowIterator(this.next);
            this.lastPartitionKey = iterator.partitionKey().getKey();
            this.next = null;
            return iterator;
        }

        private class GroupByRowIterator
        implements RowIterator {
            private RowIterator rowIterator;
            private boolean closed;

            public GroupByRowIterator(RowIterator delegate) {
                this.rowIterator = delegate;
            }

            @Override
            public TableMetadata metadata() {
                return this.rowIterator.metadata();
            }

            @Override
            public boolean isReverseOrder() {
                return this.rowIterator.isReverseOrder();
            }

            @Override
            public RegularAndStaticColumns columns() {
                return this.rowIterator.columns();
            }

            @Override
            public DecoratedKey partitionKey() {
                return this.rowIterator.partitionKey();
            }

            @Override
            public Row staticRow() {
                Row row = this.rowIterator.staticRow();
                GroupByPartitionIterator.this.lastClustering = null;
                return row;
            }

            @Override
            public boolean isEmpty() {
                return this.rowIterator.isEmpty() && !this.hasNext();
            }

            @Override
            public void close() {
                if (!this.closed) {
                    this.rowIterator.close();
                }
            }

            @Override
            public boolean hasNext() {
                if (this.rowIterator.hasNext()) {
                    return true;
                }
                DecoratedKey partitionKey = this.rowIterator.partitionKey();
                this.rowIterator.close();
                GroupByPartitionIterator.this.hasNext();
                if (GroupByPartitionIterator.this.next != null && partitionKey.equals(GroupByPartitionIterator.this.next.partitionKey())) {
                    this.rowIterator = GroupByPartitionIterator.this.next;
                    GroupByPartitionIterator.this.next = null;
                    return this.rowIterator.hasNext();
                }
                this.closed = true;
                return false;
            }

            @Override
            public Row next() {
                Row row = (Row)this.rowIterator.next();
                GroupByPartitionIterator.this.lastClustering = row.clustering();
                return row;
            }
        }
    }
}

