/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.TracingReferenceCounted;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;

public final class VanillaReferenceCounted
implements MonitorReferenceCounted {
    private static final long VALUE = UnsafeMemory.unsafeObjectFieldOffset(Jvm.getField(VanillaReferenceCounted.class, "value"));
    private final Runnable onRelease;
    @UsedViaReflection
    private volatile int value = 1;
    private volatile boolean released = false;
    private final Class type;

    VanillaReferenceCounted(Runnable onRelease, Class type) {
        this.onRelease = onRelease;
        this.type = type;
    }

    @Override
    public StackTrace createdHere() {
        return null;
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) {
        if (this.refCount() <= 0) {
            throw new IllegalStateException(this.type.getName() + " no reservations for " + TracingReferenceCounted.asString(owner));
        }
        return true;
    }

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        int v;
        do {
            if ((v = this.value) > 0) continue;
            throw new ClosedIllegalStateException(this.type.getName() + " released");
        } while (!this.valueCompareAndSet(v, v + 1));
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.throwExceptionIfReleased();
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) {
        int v;
        do {
            if ((v = this.value) > 0) continue;
            return false;
        } while (!this.valueCompareAndSet(v, v + 1));
        return true;
    }

    private boolean valueCompareAndSet(int from, int to) {
        return UnsafeMemory.INSTANCE.compareAndSwapInt(this, VALUE, from, to);
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        block1: {
            int count;
            int v;
            do {
                if ((v = this.value) > 0) continue;
                throw new ClosedIllegalStateException(this.type.getName() + " released");
            } while (!this.valueCompareAndSet(v, count = v - 1));
            if (count != 0) break block1;
            this.callOnRelease();
        }
    }

    public void callOnRelease() {
        if (this.released) {
            throw new ClosedIllegalStateException(this.type.getName() + " already released");
        }
        this.released = true;
        this.onRelease.run();
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        do {
            int v;
            if ((v = this.value) <= 0) {
                throw new ClosedIllegalStateException(this.type.getName() + " released");
            }
            if (v <= 1) continue;
            throw new IllegalStateException(this.type.getName() + " not the last released");
        } while (!this.valueCompareAndSet(1, 0));
        this.callOnRelease();
    }

    @Override
    public int refCount() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public void throwExceptionIfNotReleased() {
        if (this.refCount() > 0) {
            throw new IllegalStateException(this.type.getName() + " still reserved, count=" + this.refCount());
        }
    }

    @Override
    public void warnAndReleaseIfNotReleased() {
        if (this.refCount() > 0) {
            Slf4jExceptionHandler.WARN.on(this.type, "Discarded without being released");
            this.callOnRelease();
        }
    }
}

