/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.event;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventTransformer;
import org.gridkit.jvmtool.event.TypedEventWriter;
import org.gridkit.jvmtool.event.TypedEventWriterProvider;
import org.gridkit.jvmtool.event.UniversalEventWriter;

public class TypedEventWriterProxy {
    public static <T extends TypedEventWriter> T createWriter(Class<T> facade, TypedEventWriterProvider provider) {
        return (T)((TypedEventWriter)facade.cast(Proxy.newProxyInstance(facade.getClassLoader(), new Class[]{facade}, (InvocationHandler)new Handler(facade, provider))));
    }

    public static WriterBuilder decorate(UniversalEventWriter writer) {
        return new WriterBuilder(writer);
    }

    private static class VoidTransformer
    implements EventTransformer {
        private VoidTransformer() {
        }

        public Event transform(Event source) {
            return null;
        }
    }

    public static class WriterBuilder {
        private final List<EventTransformer<Event, Event>> tailTransformers = new ArrayList<EventTransformer<Event, Event>>();
        private final TransformingWriter root;
        private GenericEventWriterProvider provider;

        public WriterBuilder(UniversalEventWriter writer) {
            this.root = new TransformingWriter(writer, null);
            this.provider = new GenericEventWriterProvider();
        }

        public WriterBuilder morth(EventTransformer<Event, Event> transformer) {
            this.tailTransformers.add(transformer);
            return this;
        }

        public <T extends Event> WriterBuilder pass(Class<T> facade) {
            this.provider.add(facade, this.root);
            return this;
        }

        public <T extends Event> WriterBuilder pass(Class<T> facade, EventTransformer<T, Event> transformer) {
            this.provider.add(facade, new TransformingWriter(this.root, transformer));
            return this;
        }

        public <T extends Event> WriterBuilder ignore(Class<T> facade) {
            return this.pass(facade, new VoidTransformer());
        }

        public <T extends TypedEventWriter> T facade(Class<T> facade) {
            if (!this.tailTransformers.isEmpty()) {
                ChainTransformer tchain;
                EventTransformer[] chain = this.tailTransformers.toArray(new EventTransformer[0]);
                this.root.transformer = tchain = new ChainTransformer(chain);
            }
            T writer = TypedEventWriterProxy.createWriter(facade, this.provider);
            this.provider = null;
            return writer;
        }
    }

    private static class ChainTransformer
    implements EventTransformer<Event, Event> {
        private final EventTransformer<Event, Event>[] tchain;

        public ChainTransformer(EventTransformer<Event, Event>[] tchain) {
            this.tchain = tchain;
        }

        @Override
        public Event transform(Event source) {
            Event e = source;
            for (int i = this.tchain.length - 1; i >= 0; --i) {
                if ((e = this.tchain[i].transform(e)) != null) continue;
                return null;
            }
            return e;
        }
    }

    private static class TransformingWriter
    implements UniversalEventWriter {
        private final UniversalEventWriter nested;
        EventTransformer<Event, Event> transformer;

        public TransformingWriter(UniversalEventWriter nested, EventTransformer<Event, Event> transformer) {
            this.nested = nested;
            this.transformer = transformer;
        }

        @Override
        public void store(Event event) throws IOException {
            Event event2 = event = this.transformer == null ? event : this.transformer.transform(event);
            if (event != null) {
                this.nested.store(event);
            }
        }

        @Override
        public void close() throws IOException {
            this.nested.close();
        }
    }

    private static class GenericEventWriterProvider
    implements TypedEventWriterProvider {
        private Class<?>[] eventTypes = new Class[0];
        private UniversalEventWriter[] writers = new UniversalEventWriter[0];

        private GenericEventWriterProvider() {
        }

        @Override
        public <T extends Event> UniversalEventWriter getWriterFor(Class<T> eventInterface) {
            int n = 0;
            for (Class<T> clazz : this.eventTypes) {
                if (clazz.isAssignableFrom(eventInterface)) {
                    return this.writers[n];
                }
                ++n;
            }
            throw new IllegalArgumentException("Event type " + eventInterface.getSimpleName() + " is not supported");
        }

        @Override
        public void close() {
            for (UniversalEventWriter writer : this.writers) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public void add(Class<?> facade, UniversalEventWriter writer) {
            int n = this.eventTypes.length;
            this.eventTypes = Arrays.copyOf(this.eventTypes, n + 1);
            this.writers = Arrays.copyOf(this.writers, n + 1);
            this.eventTypes[n] = facade;
            this.writers[n] = writer;
        }
    }

    private static class Handler
    implements InvocationHandler {
        private final Class<?> facade;
        private final TypedEventWriterProvider provider;
        private final Map<Method, UniversalEventWriter> methodMap = new HashMap<Method, UniversalEventWriter>();

        public Handler(Class<?> facade, TypedEventWriterProvider provider) {
            this.facade = facade;
            this.provider = provider;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if ("close".equals(method.getName()) && method.getParameterTypes().length == 0) {
                this.provider.close();
            } else {
                UniversalEventWriter writer = this.writerFor(method);
                writer.store((Event)args[0]);
            }
            return null;
        }

        private UniversalEventWriter writerFor(Method method) {
            if (this.methodMap.containsKey(method)) {
                return this.methodMap.get(method);
            }
            if (method.getParameterTypes().length == 1 && Event.class.isAssignableFrom(method.getParameterTypes()[0]) && method.getParameterTypes()[0].isInterface() && Event.class.isAssignableFrom(method.getParameterTypes()[0]) && method.getReturnType() == Void.TYPE) {
                Class<?> type = method.getParameterTypes()[0];
                UniversalEventWriter writer = this.provider.getWriterFor(type);
                this.methodMap.put(method, writer);
                return writer;
            }
            throw new IllegalArgumentException("Invalid event write method " + method.getName());
        }

        public String toString() {
            return this.facade.getSimpleName() + "(" + this.provider + ")";
        }
    }
}

