/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

public class IntList {
    private int[] entries;
    private int count;

    public IntList() {
        this(10);
    }

    public IntList(int capacity) {
        this.entries = new int[capacity];
    }

    public static IntList filledWithRange(int start, int end) {
        IntList list = new IntList(end - start);
        int val = start;
        while (val < end) {
            list.add(val);
            ++val;
        }
        return list;
    }

    public int size() {
        return this.count;
    }

    public boolean contains(int value) {
        int i2 = 0;
        while (i2 < this.count) {
            if (this.entries[i2] == value) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public int get(int i2) {
        if (this.count <= i2) {
            throw new ArrayIndexOutOfBoundsException(i2);
        }
        return this.entries[i2];
    }

    public void clear() {
        this.count = 0;
    }

    public void add(int n) {
        if (this.count == this.entries.length) {
            this.grow();
        }
        this.entries[this.count++] = n;
    }

    public void set(int index2, int n) {
        if (this.count < index2) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        if (this.count == index2) {
            this.add(n);
        } else {
            this.entries[index2] = n;
        }
    }

    public void fillTo(int toIndex, int val) {
        while (this.count < toIndex) {
            this.add(val);
        }
    }

    public void sort(IntComparator comparator) {
        this.quickSort(0, this.count - 1, comparator);
    }

    private void quickSort(int begin, int end, IntComparator comparator) {
        if (begin < end) {
            int partitionIndex = this.partition(begin, end, comparator);
            this.quickSort(begin, partitionIndex - 1, comparator);
            this.quickSort(partitionIndex + 1, end, comparator);
        }
    }

    private int partition(int begin, int end, IntComparator comparator) {
        int pivot = this.entries[end];
        int writeSmallerIdx = begin - 1;
        int findSmallerIdx = begin;
        while (findSmallerIdx < end) {
            if (comparator.compare(this.entries[findSmallerIdx], pivot) <= 0) {
                int biggerVal = this.entries[++writeSmallerIdx];
                this.entries[writeSmallerIdx] = this.entries[findSmallerIdx];
                this.entries[findSmallerIdx] = biggerVal;
            }
            ++findSmallerIdx;
        }
        int pivotIdx = writeSmallerIdx + 1;
        this.entries[end] = this.entries[pivotIdx];
        this.entries[pivotIdx] = pivot;
        return pivotIdx;
    }

    private void grow() {
        int[] n = new int[(this.entries.length + 16) * 3 / 2];
        System.arraycopy(this.entries, 0, n, 0, this.count);
        this.entries = n;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append('[');
        int i2 = 0;
        while (i2 < this.count) {
            if (i2 > 0) {
                r.append(", ");
            }
            r.append(this.entries[i2]);
            ++i2;
        }
        r.append(']');
        return r.toString();
    }

    public static interface IntComparator {
        public int compare(int var1, int var2);
    }
}

