/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

class TypeStringFormatter {
    TypeStringFormatter() {
    }

    static String format(Type type) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            Class<?> enclosingClass = aClass.getEnclosingClass();
            if (enclosingClass != null) {
                String ownName = aClass.isAnonymousClass() ? "<anonymous>" : aClass.getSimpleName();
                return TypeStringFormatter.format(enclosingClass) + "$" + ownName;
            }
            return aClass.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(TypeStringFormatter.format(parameterizedType.getRawType()));
            builder.append("<");
            for (int i2 = 0; i2 < parameterizedType.getActualTypeArguments().length; ++i2) {
                Type typeParam = parameterizedType.getActualTypeArguments()[i2];
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(TypeStringFormatter.format(typeParam));
            }
            builder.append(">");
            return builder.toString();
        }
        return type.toString();
    }
}

