/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.document.config;

import groovy.lang.Closure;
import org.grails.datastore.mapping.config.AbstractGormMappingFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.document.config.Attribute;
import org.grails.datastore.mapping.document.config.Collection;
import org.grails.datastore.mapping.document.config.DocumentPersistentEntity;
import org.grails.datastore.mapping.document.config.GormDocumentMappingFactory;
import org.grails.datastore.mapping.model.AbstractMappingContext;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.JpaMappingConfigurationStrategy;
import org.springframework.util.Assert;

public class DocumentMappingContext
extends AbstractMappingContext {
    protected String defaultDatabaseName;
    protected MappingFactory<Collection, Attribute> mappingFactory;
    private MappingConfigurationStrategy syntaxStrategy;
    private Closure defaultMapping;

    public DocumentMappingContext(String defaultDatabaseName, ConnectionSourceSettings settings) {
        super(settings);
        Assert.notNull((Object)defaultDatabaseName, "Argument [defaultDatabaseName] cannot be null");
        this.defaultDatabaseName = defaultDatabaseName;
    }

    @Deprecated
    public DocumentMappingContext(String defaultDatabaseName) {
        Assert.notNull((Object)defaultDatabaseName, "Argument [defaultDatabaseName] cannot be null");
        this.defaultDatabaseName = defaultDatabaseName;
        this.mappingFactory = this.createDocumentMappingFactory(null);
        this.syntaxStrategy = new JpaMappingConfigurationStrategy(this.mappingFactory);
    }

    @Deprecated
    public DocumentMappingContext(String defaultDatabaseName, Closure defaultMapping) {
        Assert.notNull((Object)defaultDatabaseName, "Argument [defaultDatabaseName] cannot be null");
        this.defaultDatabaseName = defaultDatabaseName;
        this.mappingFactory = this.createDocumentMappingFactory(defaultMapping);
        this.defaultMapping = defaultMapping;
        this.syntaxStrategy = new JpaMappingConfigurationStrategy(this.mappingFactory);
    }

    @Override
    protected void initialize(ConnectionSourceSettings settings) {
        this.defaultMapping = settings.getDefault().getMapping();
        AbstractGormMappingFactory documentMappingFactory = (AbstractGormMappingFactory)this.createDocumentMappingFactory(this.defaultMapping);
        documentMappingFactory.setDefaultConstraints(settings.getDefault().getConstraints());
        this.mappingFactory = documentMappingFactory;
        this.syntaxStrategy = new JpaMappingConfigurationStrategy(this.mappingFactory);
        super.initialize(settings);
    }

    public Closure getDefaultMapping() {
        return this.defaultMapping;
    }

    protected MappingFactory createDocumentMappingFactory(Closure defaultMapping) {
        GormDocumentMappingFactory gormDocumentMappingFactory = new GormDocumentMappingFactory();
        gormDocumentMappingFactory.setDefaultMapping(defaultMapping);
        return gormDocumentMappingFactory;
    }

    public String getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    @Override
    public MappingConfigurationStrategy getMappingSyntaxStrategy() {
        return this.syntaxStrategy;
    }

    @Override
    public MappingFactory<Collection, Attribute> getMappingFactory() {
        return this.mappingFactory;
    }

    @Override
    protected PersistentEntity createPersistentEntity(Class javaClass) {
        return new DocumentPersistentEntity(javaClass, this);
    }

    @Override
    protected PersistentEntity createPersistentEntity(Class javaClass, boolean external) {
        return new DocumentPersistentEntity(javaClass, this, external);
    }
}

