/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.grails;

import jakarta.inject.Singleton;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.CoordinateResolver;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.gradle.GradlePlugin;
import org.grails.forge.feature.DefaultFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.view.GrailsGsp;
import org.grails.forge.feature.web.GrailsWeb;
import org.grails.forge.options.Options;

@Singleton
class GrailsGradlePlugin
implements DefaultFeature {
    private final CoordinateResolver resolver;

    GrailsGradlePlugin(CoordinateResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public String getName() {
        return "grails-gradle-plugin";
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return true;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        ApplicationType applicationType = generatorContext.getApplicationType();
        generatorContext.addBuildscriptDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-gradle-plugins").buildSrc());
        if (applicationType == ApplicationType.PLUGIN || applicationType == ApplicationType.WEB_PLUGIN) {
            generatorContext.addBuildPlugin(GradlePlugin.builder().id("org.apache.grails.gradle.grails-plugin").useApplyPlugin(true).build());
        }
        if (generatorContext.getFeature(GrailsWeb.class).isPresent()) {
            generatorContext.addBuildPlugin(GradlePlugin.builder().id("org.apache.grails.gradle.grails-web").useApplyPlugin(true).build());
        }
        if (generatorContext.getFeature(GrailsGsp.class).isPresent()) {
            generatorContext.addBuildPlugin(GradlePlugin.builder().id("org.apache.grails.gradle.grails-gsp").useApplyPlugin(true).build());
        }
    }
}

