/*
 * Decompiled with CFR 0.152.
 */
package grails.core;

import grails.core.ArtefactHandler;
import grails.core.ArtefactInfo;
import grails.core.GrailsClass;
import grails.util.GrailsNameUtils;
import groovy.lang.Closure;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.core.exceptions.GrailsRuntimeException;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.Resource;
import org.grails.io.support.UrlResource;

public abstract class ArtefactHandlerAdapter
implements ArtefactHandler {
    protected String type;
    protected Class<?> grailsClassType;
    protected Class<?> grailsClassImpl;
    protected boolean allowAbstract;
    protected String artefactSuffix;

    public ArtefactHandlerAdapter(String type, Class<? extends GrailsClass> grailsClassType, Class<?> grailsClassImpl, String artefactSuffix) {
        this.artefactSuffix = artefactSuffix;
        this.type = type;
        this.grailsClassType = grailsClassType;
        this.grailsClassImpl = grailsClassImpl;
    }

    public ArtefactHandlerAdapter(String type, Class<? extends GrailsClass> grailsClassType, Class<?> grailsClassImpl, String artefactSuffix, boolean allowAbstract) {
        this.artefactSuffix = artefactSuffix;
        this.type = type;
        this.grailsClassType = grailsClassType;
        this.grailsClassImpl = grailsClassImpl;
        this.allowAbstract = allowAbstract;
    }

    @Override
    public String getPluginName() {
        return GrailsNameUtils.getPropertyName(this.type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isArtefact(ClassNode classNode) {
        String name;
        int modifiers = classNode.getModifiers();
        URL url = GrailsASTUtils.getSourceUrl(classNode);
        if (url == null) {
            return false;
        }
        try {
            UrlResource resource = new UrlResource(url);
            if (!this.isArtefactResource(resource)) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return this.isValidArtefactClassNode(classNode, modifiers) && (name = classNode.getName()) != null && this.artefactSuffix != null && name.endsWith(this.artefactSuffix);
    }

    protected boolean isValidArtefactClassNode(ClassNode classNode, int modifiers) {
        return !classNode.isEnum() && !classNode.isInterface() && !(classNode instanceof InnerClassNode);
    }

    protected boolean isArtefactResource(Resource resource) throws IOException {
        return GrailsResourceUtils.isGrailsResource(resource);
    }

    @Override
    public final boolean isArtefact(Class aClass) {
        if (aClass == null) {
            return false;
        }
        try {
            if (this.isArtefactClass(aClass)) {
                return true;
            }
        }
        catch (Throwable t) {
            throw new GrailsRuntimeException("Failed to introspect class: " + String.valueOf(aClass), t);
        }
        return false;
    }

    public boolean isArtefactClass(Class clazz) {
        boolean ok;
        if (clazz == null) {
            return false;
        }
        boolean bl = ok = clazz.getName().endsWith(this.artefactSuffix) && !Closure.class.isAssignableFrom(clazz);
        if (ok && !this.allowAbstract) {
            ok &= !Modifier.isAbstract(clazz.getModifiers());
        }
        return ok;
    }

    @Override
    public GrailsClass newArtefactClass(Class artefactClass) {
        try {
            Constructor<?> c = this.grailsClassImpl.getDeclaredConstructor(Class.class);
            return (GrailsClass)c.newInstance(artefactClass);
        }
        catch (NoSuchMethodException e) {
            throw new GrailsRuntimeException("Unable to locate constructor with Class parameter for " + String.valueOf(artefactClass), e);
        }
        catch (IllegalAccessException e) {
            throw new GrailsRuntimeException("Unable to locate constructor with Class parameter for " + String.valueOf(artefactClass), e);
        }
        catch (InvocationTargetException e) {
            throw new GrailsRuntimeException("Error instantiated artefact class [" + String.valueOf(artefactClass) + "] of type [" + String.valueOf(this.grailsClassImpl) + "]: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()), e);
        }
        catch (InstantiationException e) {
            throw new GrailsRuntimeException("Error instantiated artefact class [" + String.valueOf(artefactClass) + "] of type [" + String.valueOf(this.grailsClassImpl) + "]: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()), e);
        }
    }

    @Override
    public void initialize(ArtefactInfo artefacts) {
    }

    @Override
    public GrailsClass getArtefactForFeature(Object feature) {
        return null;
    }

    @Override
    public boolean isArtefactGrailsClass(GrailsClass artefactGrailsClass) {
        return this.grailsClassType.isAssignableFrom(artefactGrailsClass.getClass());
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

