/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.scan;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class DefaultClassPathResourceLoader
implements ClassPathResourceLoader {
    private final Logger log;
    private final ClassLoader classLoader;
    private final String basePath;
    private final URL baseURL;
    private final Map<String, Boolean> isDirectoryCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(50L).build();
    private final boolean missingPath;
    private final boolean checkBase;

    public DefaultClassPathResourceLoader(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public DefaultClassPathResourceLoader(ClassLoader classLoader, String basePath) {
        this(classLoader, basePath, false);
    }

    public DefaultClassPathResourceLoader(ClassLoader classLoader, String basePath, boolean checkBase) {
        this(classLoader, basePath, checkBase, true);
    }

    public DefaultClassPathResourceLoader(ClassLoader classLoader, String basePath, boolean checkBase, boolean logEnabled) {
        this.log = logEnabled ? LoggerFactory.getLogger(this.getClass()) : NOPLogger.NOP_LOGGER;
        this.classLoader = classLoader;
        this.basePath = this.normalize(basePath);
        this.baseURL = checkBase && basePath != null ? classLoader.getResource(this.normalize(basePath)) : null;
        this.missingPath = checkBase && basePath != null && this.baseURL == null;
        this.checkBase = checkBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<InputStream> getResourceAsStream(String path) {
        if (this.missingPath) {
            return Optional.empty();
        }
        if (this.isProhibitedRelativePath(path)) {
            return Optional.empty();
        }
        URL url = this.classLoader.getResource(this.prefixPath(path));
        if (url != null && this.startsWithBase(url)) {
            try {
                URI uri = url.toURI();
                if (uri.getScheme().equals("jar")) {
                    Class<DefaultClassPathResourceLoader> clazz = DefaultClassPathResourceLoader.class;
                    synchronized (DefaultClassPathResourceLoader.class) {
                        Optional<InputStream> optional;
                        Path pathObject;
                        FileSystem fileSystem;
                        block27: {
                            fileSystem = null;
                            try {
                                String altPath;
                                Path altPathObject;
                                try {
                                    fileSystem = FileSystems.getFileSystem(uri);
                                }
                                catch (FileSystemNotFoundException fileSystemNotFoundException) {
                                    // empty catch block
                                }
                                if (fileSystem == null || !fileSystem.isOpen()) {
                                    try {
                                        fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap(), this.classLoader);
                                    }
                                    catch (FileSystemAlreadyExistsException e) {
                                        fileSystem = FileSystems.getFileSystem(uri);
                                    }
                                }
                                if (!Files.exists(pathObject = fileSystem.getPath(path, new String[0]), new LinkOption[0]) && uri.toString().contains("!/") && Files.exists(altPathObject = fileSystem.getPath(altPath = Arrays.stream(uri.toString().split("\\!\\/")).skip(1L).collect(Collectors.joining("/")), new String[0]), new LinkOption[0]) && !Files.isDirectory(pathObject, new LinkOption[0])) {
                                    pathObject = altPathObject;
                                }
                                if (!Files.isDirectory(pathObject, new LinkOption[0])) break block27;
                                optional = Optional.empty();
                                if (fileSystem == null) return optional;
                                if (!fileSystem.isOpen()) return optional;
                            }
                            catch (Throwable throwable) {
                                if (fileSystem == null) throw throwable;
                                if (!fileSystem.isOpen()) throw throwable;
                                try {
                                    fileSystem.close();
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    this.log.debug("Error shutting down JAR file system [{}]: {}", fileSystem, e.getMessage(), e);
                                }
                                throw throwable;
                            }
                            try {
                                fileSystem.close();
                            }
                            catch (IOException e) {
                                this.log.debug("Error shutting down JAR file system [{}]: {}", fileSystem, e.getMessage(), e);
                            }
                            return optional;
                        }
                        optional = Optional.of(new ByteArrayInputStream(Files.readAllBytes(pathObject)));
                        if (fileSystem == null) return optional;
                        if (!fileSystem.isOpen()) return optional;
                        try {
                            fileSystem.close();
                        }
                        catch (IOException e) {
                            this.log.debug("Error shutting down JAR file system [{}]: {}", fileSystem, e.getMessage(), e);
                        }
                        return optional;
                    }
                }
                if (uri.getScheme().equals("file")) {
                    Path pathObject = Paths.get(uri);
                    if (!Files.isDirectory(pathObject, new LinkOption[0])) return Optional.of(Files.newInputStream(pathObject, new OpenOption[0]));
                    return Optional.empty();
                }
            }
            catch (IOException | URISyntaxException | ProviderNotFoundException e) {
                this.log.debug("Error establishing whether path is a directory: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (path.indexOf(46) == -1) {
            return Optional.empty();
        }
        URL u = this.getResource(path).orElse(null);
        if (u == null) return Optional.empty();
        try {
            return Optional.of(u.openStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private boolean startsWithBase(URL url) {
        if (this.checkBase) {
            if (this.baseURL == null) {
                return true;
            }
            return url.toExternalForm().startsWith(this.baseURL.toExternalForm());
        }
        return true;
    }

    @Override
    public Optional<URL> getResource(String path) {
        URL url;
        if (this.missingPath) {
            return Optional.empty();
        }
        if (this.isProhibitedRelativePath(path)) {
            return Optional.empty();
        }
        boolean isDirectory = this.isDirectory(path);
        if (!isDirectory && (url = this.classLoader.getResource(this.prefixPath(path))) != null && this.startsWithBase(url)) {
            return Optional.of(url);
        }
        return Optional.empty();
    }

    private boolean isProhibitedRelativePath(String path) {
        return !this.checkBase && path.replace('\\', '/').contains("../");
    }

    @Override
    public Stream<URL> getResources(String path) {
        Enumeration<URL> all;
        if (this.missingPath) {
            return Stream.empty();
        }
        if (this.isProhibitedRelativePath(path)) {
            return Stream.empty();
        }
        try {
            all = this.classLoader.getResources(this.prefixPath(path));
        }
        catch (IOException e) {
            return Stream.empty();
        }
        Stream.Builder<URL> builder = Stream.builder();
        while (all.hasMoreElements()) {
            URL url = all.nextElement();
            if (!this.startsWithBase(url)) continue;
            builder.accept(url);
        }
        return builder.build();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ResourceLoader forBase(String basePath) {
        return new DefaultClassPathResourceLoader(this.classLoader, basePath);
    }

    public ResourceLoader forBase(String basePath, boolean logEnabled) {
        return new DefaultClassPathResourceLoader(this.classLoader, basePath, false, logEnabled);
    }

    private String normalize(String path) {
        if (path != null) {
            if (path.startsWith("classpath:")) {
                path = path.substring(10);
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.endsWith("/") && StringUtils.isNotEmpty(path)) {
                path = path + "/";
            }
        }
        return path;
    }

    private boolean isDirectory(String path) {
        return this.isDirectoryCache.computeIfAbsent(path, s -> {
            boolean bl;
            URL url = this.classLoader.getResource(this.prefixPath(path));
            if (url != null) {
                try {
                    URI uri = url.toURI();
                    if (uri.getScheme().equals("jar")) {
                        Class<DefaultClassPathResourceLoader> clazz = DefaultClassPathResourceLoader.class;
                        synchronized (DefaultClassPathResourceLoader.class) {
                            Boolean bl2;
                            FileSystem fileSystem = null;
                            try {
                                Path pathObject;
                                try {
                                    fileSystem = FileSystems.getFileSystem(uri);
                                }
                                catch (FileSystemNotFoundException fileSystemNotFoundException) {
                                    // empty catch block
                                }
                                if (fileSystem == null || !fileSystem.isOpen()) {
                                    fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap(), this.classLoader);
                                }
                                bl2 = (pathObject = fileSystem.getPath(path, new String[0])) == null || Files.isDirectory(pathObject, new LinkOption[0]);
                                if (fileSystem == null) return bl2;
                                if (!fileSystem.isOpen()) return bl2;
                            }
                            catch (Throwable throwable) {
                                if (fileSystem == null) throw throwable;
                                if (!fileSystem.isOpen()) throw throwable;
                                try {
                                    fileSystem.close();
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    this.log.debug("Error shutting down JAR file system [{}]: {}", fileSystem, e.getMessage(), e);
                                }
                                throw throwable;
                            }
                            try {
                                fileSystem.close();
                            }
                            catch (IOException e) {
                                this.log.debug("Error shutting down JAR file system [{}]: {}", fileSystem, e.getMessage(), e);
                            }
                            return bl2;
                        }
                    }
                    if (uri.getScheme().equals("file")) {
                        boolean bl3;
                        Path pathObject = Paths.get(uri);
                        if (pathObject != null && !Files.isDirectory(pathObject, new LinkOption[0])) {
                            bl3 = false;
                            return bl3;
                        }
                        bl3 = true;
                        return bl3;
                    }
                }
                catch (IOException | URISyntaxException | ProviderNotFoundException e) {
                    this.log.debug("Error establishing whether path is a directory: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (path.indexOf(46) == -1) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        });
    }

    private String prefixPath(String path) {
        if (path.startsWith("classpath:")) {
            path = path.substring(10);
        }
        if (this.basePath != null) {
            if (path.startsWith("/")) {
                return this.basePath + path.substring(1);
            }
            return this.basePath + path;
        }
        return path;
    }
}

