/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
public class NettyHttpHeaders
implements MutableHttpHeaders {
    HttpHeaders nettyHeaders;
    final ConversionService<?> conversionService;

    public NettyHttpHeaders(HttpHeaders nettyHeaders, ConversionService conversionService) {
        this.nettyHeaders = nettyHeaders;
        this.conversionService = conversionService;
    }

    public NettyHttpHeaders() {
        this.nettyHeaders = new DefaultHttpHeaders();
        this.conversionService = ConversionService.SHARED;
    }

    public HttpHeaders getNettyHeaders() {
        return this.nettyHeaders;
    }

    @Override
    public final boolean contains(String name) {
        return this.nettyHeaders.contains(name);
    }

    void setNettyHeaders(HttpHeaders headers) {
        this.nettyHeaders = headers;
    }

    @Override
    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        List<String> values = this.nettyHeaders.getAll(name);
        if (!values.isEmpty()) {
            if (values.size() == 1 || !this.isCollectionOrArray(conversionContext.getArgument().getType())) {
                return this.conversionService.convert((Object)values.get(0), conversionContext);
            }
            return this.conversionService.convert(values, conversionContext);
        }
        return Optional.empty();
    }

    private boolean isCollectionOrArray(Class<?> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.nettyHeaders.getAll(name);
    }

    @Override
    public Set<String> names() {
        return this.nettyHeaders.names();
    }

    @Override
    public Collection<List<String>> values() {
        Set<String> names = this.names();
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (String name : names) {
            values.add(this.getAll(name));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public String get(CharSequence name) {
        return this.nettyHeaders.get(name);
    }

    @Override
    public MutableHttpHeaders add(CharSequence header, CharSequence value) {
        this.nettyHeaders.add(header, (Object)value);
        return this;
    }

    @Override
    public MutableHeaders set(CharSequence header, CharSequence value) {
        this.nettyHeaders.set(header, (Object)value);
        return this;
    }

    @Override
    public MutableHttpHeaders remove(CharSequence header) {
        this.nettyHeaders.remove(header);
        return this;
    }

    @Override
    public MutableHttpHeaders date(LocalDateTime date) {
        if (date != null) {
            this.add((CharSequence)HttpHeaderNames.DATE, ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    @Override
    public MutableHttpHeaders expires(LocalDateTime date) {
        if (date != null) {
            this.add((CharSequence)HttpHeaderNames.EXPIRES, ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    @Override
    public MutableHttpHeaders lastModified(LocalDateTime date) {
        if (date != null) {
            this.add((CharSequence)HttpHeaderNames.LAST_MODIFIED, ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    @Override
    public MutableHttpHeaders ifModifiedSince(LocalDateTime date) {
        if (date != null) {
            this.add((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    @Override
    public MutableHttpHeaders date(long timeInMillis) {
        this.add((CharSequence)HttpHeaderNames.DATE, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    @Override
    public MutableHttpHeaders expires(long timeInMillis) {
        this.add((CharSequence)HttpHeaderNames.EXPIRES, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    @Override
    public MutableHttpHeaders lastModified(long timeInMillis) {
        this.add((CharSequence)HttpHeaderNames.LAST_MODIFIED, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    @Override
    public MutableHttpHeaders ifModifiedSince(long timeInMillis) {
        this.add((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    @Override
    public MutableHttpHeaders auth(String userInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("Basic");
        sb.append(" ");
        sb.append(Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.ISO_8859_1)));
        String token = sb.toString();
        this.add((CharSequence)HttpHeaderNames.AUTHORIZATION, token);
        return this;
    }

    @Override
    public MutableHttpHeaders allowGeneric(Collection<? extends CharSequence> methods) {
        String value = methods.stream().distinct().collect(Collectors.joining(","));
        return this.add((CharSequence)HttpHeaderNames.ALLOW, value);
    }

    @Override
    public MutableHttpHeaders location(URI uri) {
        return this.add((CharSequence)HttpHeaderNames.LOCATION, uri.toString());
    }

    @Override
    public MutableHttpHeaders contentType(MediaType mediaType) {
        return this.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, mediaType);
    }
}

