/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;

public class StrategyOneSided
extends MergeStrategy {
    private final String strategyName;
    private final int treeIndex;

    protected StrategyOneSided(String name, int index2) {
        this.strategyName = name;
        this.treeIndex = index2;
    }

    @Override
    public String getName() {
        return this.strategyName;
    }

    @Override
    public Merger newMerger(Repository db) {
        return new OneSide(db, this.treeIndex);
    }

    @Override
    public Merger newMerger(Repository db, boolean inCore) {
        return new OneSide(db, this.treeIndex);
    }

    @Override
    public Merger newMerger(ObjectInserter inserter, Config config) {
        return new OneSide(inserter, this.treeIndex);
    }

    static class OneSide
    extends Merger {
        private final int treeIndex;

        protected OneSide(Repository local, int index2) {
            super(local);
            this.treeIndex = index2;
        }

        protected OneSide(ObjectInserter inserter, int index2) {
            super(inserter);
            this.treeIndex = index2;
        }

        @Override
        protected boolean mergeImpl() throws IOException {
            return this.treeIndex < this.sourceTrees.length;
        }

        @Override
        public ObjectId getResultTreeId() {
            return this.sourceTrees[this.treeIndex];
        }

        @Override
        public ObjectId getBaseCommitId() {
            return null;
        }
    }
}

